/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen;

import com.amazonaws.codegen.AstJsonToAstJava;
import com.amazonaws.codegen.model.intermediate.AcceptorModel;
import com.amazonaws.codegen.model.intermediate.OperationModel;
import com.amazonaws.codegen.model.intermediate.WaiterDefinitionModel;
import com.amazonaws.codegen.model.service.Acceptor;
import com.amazonaws.codegen.model.service.WaiterDefinition;
import com.amazonaws.codegen.model.service.Waiters;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.util.IOUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class AddWaiters {
    private static final ObjectMapper mapper = new ObjectMapper();
    private final Waiters waiters;
    private final Map<String, OperationModel> operations;

    AddWaiters(Waiters waiters, Map<String, OperationModel> operations) {
        this.waiters = waiters;
        this.operations = operations;
    }

    Map<String, WaiterDefinitionModel> constructWaiters() throws IOException {
        HashMap<String, WaiterDefinitionModel> javaWaiterModels = new HashMap<String, WaiterDefinitionModel>();
        HashMap<String, JmesPathExpression> argumentToAstMap = new HashMap<String, JmesPathExpression>();
        for (Map.Entry<String, WaiterDefinition> entry : this.waiters.getWaiters().entrySet()) {
            String waiterName = entry.getKey();
            WaiterDefinition waiterDefinition = entry.getValue();
            ArrayList<AcceptorModel> acceptors = new ArrayList<AcceptorModel>();
            WaiterDefinitionModel waiterDefinitionModel = new WaiterDefinitionModel();
            waiterDefinitionModel.setDelay(waiterDefinition.getDelay());
            waiterDefinitionModel.setMaxAttempts(waiterDefinition.getMaxAttempts());
            waiterDefinitionModel.setWaiterName(waiterName);
            waiterDefinitionModel.setOperationModel(this.operations.get(waiterDefinition.getOperation()));
            for (Acceptor acceptor : waiterDefinition.getAcceptors()) {
                AcceptorModel acceptorModel = new AcceptorModel();
                acceptorModel.setMatcher(acceptor.getMatcher());
                acceptorModel.setState(acceptor.getState());
                acceptorModel.setExpected(acceptor.getExpected());
                acceptorModel.setArgument(acceptor.getArgument());
                acceptorModel.setAst(AddWaiters.getAstFromArgument(acceptor.getArgument(), argumentToAstMap));
                acceptors.add(acceptorModel);
            }
            waiterDefinitionModel.setAcceptors(acceptors);
            javaWaiterModels.put(waiterName, waiterDefinitionModel);
        }
        return javaWaiterModels;
    }

    private static JmesPathExpression getAstFromArgument(String argument, Map<String, JmesPathExpression> argumentToAstMap) throws IOException {
        if (argument != null && !argumentToAstMap.containsKey(argument)) {
            ProcessBuilder pb = new ProcessBuilder("/apollo/env/SDETools/bin/brazil-runtime-exec", "python3.4", System.getProperty("codeGenSourceDirectory") + "/bin/jp-to-ast.py", argument);
            Process p = pb.start();
            JsonNode jsonNode = mapper.readTree(IOUtils.toString((InputStream)p.getInputStream()));
            JmesPathExpression ast = AstJsonToAstJava.fromAstJsonToAstJava(jsonNode);
            argumentToAstMap.put(argument, ast);
            IOUtils.closeQuietly((Closeable)p.getInputStream(), null);
            return ast;
        }
        if (argument != null) {
            return argumentToAstMap.get(argument);
        }
        return null;
    }
}

