/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen;

import com.amazonaws.codegen.internal.NameUtils;
import com.amazonaws.codegen.internal.Utils;
import com.amazonaws.codegen.model.intermediate.ExceptionModel;
import com.amazonaws.codegen.model.intermediate.OperationModel;
import com.amazonaws.codegen.model.intermediate.ReturnTypeModel;
import com.amazonaws.codegen.model.intermediate.VariableModel;
import com.amazonaws.codegen.model.service.AuthType;
import com.amazonaws.codegen.model.service.ErrorMap;
import com.amazonaws.codegen.model.service.Input;
import com.amazonaws.codegen.model.service.Member;
import com.amazonaws.codegen.model.service.Operation;
import com.amazonaws.codegen.model.service.Output;
import com.amazonaws.codegen.model.service.ServiceModel;
import com.amazonaws.codegen.model.service.Shape;
import java.util.Map;
import java.util.TreeMap;

final class AddOperations {
    AddOperations() {
    }

    public static Map<String, OperationModel> constructOperations(ServiceModel serviceModel) {
        TreeMap<String, OperationModel> javaOperationModels = new TreeMap<String, OperationModel>();
        Map<String, Shape> c2jShapes = serviceModel.getShapes();
        for (Map.Entry<String, Operation> entry : serviceModel.getOperations().entrySet()) {
            String documentation;
            Output output;
            String operationName = entry.getKey();
            Operation op = entry.getValue();
            OperationModel operationModel = new OperationModel();
            operationModel.setOperationName(operationName);
            operationModel.setDeprecated(op.isDeprecated());
            operationModel.setDocumentation(op.getDocumentation());
            operationModel.setIsAuthenticated(AddOperations.isAuthenticated(op));
            Input input = op.getInput();
            if (input != null) {
                String originalShapeName = input.getShape();
                String inputShape = NameUtils.getRequestClassName(originalShapeName, operationName);
                String documentation2 = input.getDocumentation() != null ? input.getDocumentation() : c2jShapes.get(originalShapeName).getDocumentation();
                operationModel.setInput(new VariableModel(Utils.unCapitialize(inputShape), inputShape).withDocumentation(documentation2));
            }
            if ((output = op.getOutput()) != null) {
                Shape outputShape = c2jShapes.get(output.getShape());
                String responseClassName = NameUtils.getResponseClassName(output.getShape(), operationName);
                documentation = AddOperations.getOperationDocumentation(output, outputShape);
                operationModel.setReturnType(new ReturnTypeModel(responseClassName).withDocumentation(documentation));
                if (AddOperations.isBlobShape(AddOperations.getPayloadShape(c2jShapes, outputShape))) {
                    operationModel.setHasBlobMemberAsPayload(true);
                }
            }
            if (op.getErrors() != null) {
                for (ErrorMap error : op.getErrors()) {
                    documentation = error.getDocumentation() != null ? error.getDocumentation() : c2jShapes.get(error.getShape()).getDocumentation();
                    operationModel.addException(new ExceptionModel(NameUtils.getExceptionName(error.getShape())).withDocumentation(documentation));
                }
            }
            operationModel.setInputStreamPropertyName(null);
            javaOperationModels.put(operationName, operationModel);
        }
        return javaOperationModels;
    }

    private static boolean isAuthenticated(Operation op) {
        return op.getAuthType() == null || op.getAuthType() != AuthType.NONE;
    }

    private static String getOperationDocumentation(Output output, Shape outputShape) {
        return output.getDocumentation() != null ? output.getDocumentation() : outputShape.getDocumentation();
    }

    private static boolean isBlobShape(Shape shape) {
        return shape != null && "blob".equals(shape.getType());
    }

    public static Shape getPayloadShape(Map<String, Shape> c2jShapes, Shape outputShape) {
        if (outputShape.getPayload() == null) {
            return null;
        }
        Member payloadMember = outputShape.getMembers().get(outputShape.getPayload());
        return c2jShapes.get(payloadMember.getShape());
    }
}

