/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen;

import com.amazonaws.codegen.internal.NameUtils;
import com.amazonaws.codegen.internal.Utils;
import com.amazonaws.codegen.model.intermediate.OperationModel;
import com.amazonaws.codegen.model.intermediate.ShapeModel;
import com.amazonaws.codegen.model.intermediate.ShapeType;
import com.amazonaws.codegen.model.intermediate.VariableModel;
import com.amazonaws.codegen.model.service.Input;
import com.amazonaws.codegen.model.service.Operation;
import com.amazonaws.codegen.model.service.ServiceModel;
import java.util.HashMap;
import java.util.Map;

final class AddEmptyInputShape {
    AddEmptyInputShape() {
    }

    public static Map<String, ShapeModel> addEmptyInputShapes(Map<String, OperationModel> javaOperationMap, ServiceModel service) {
        Map<String, Operation> operations = service.getOperations();
        HashMap<String, ShapeModel> emptyInputShapes = new HashMap<String, ShapeModel>();
        for (Map.Entry<String, Operation> entry : operations.entrySet()) {
            String operationName = entry.getKey();
            Operation operation = entry.getValue();
            Input input = operation.getInput();
            if (input != null) continue;
            String inputShape = operationName + "Request";
            OperationModel operationModel = javaOperationMap.get(operationName);
            operationModel.setInput(new VariableModel(Utils.unCapitialize(inputShape), inputShape));
            ShapeModel shape = new ShapeModel(inputShape).withType(ShapeType.Request.getValue());
            shape.setShapeName(inputShape);
            VariableModel inputVariable = new VariableModel(NameUtils.getVariableName(inputShape), inputShape);
            shape.setVariable(inputVariable);
            shape.setMarshaller(Utils.createInputShapeMarshaller(service.getMetadata(), operation));
            emptyInputShapes.put(inputShape, shape);
        }
        return emptyInputShapes;
    }
}

