/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen;

import com.amazonaws.codegen.internal.DocumentationUtils;
import com.amazonaws.codegen.internal.NameUtils;
import com.amazonaws.codegen.internal.TypeUtils;
import com.amazonaws.codegen.internal.Utils;
import com.amazonaws.codegen.model.config.customization.CustomizationConfig;
import com.amazonaws.codegen.model.intermediate.EnumModel;
import com.amazonaws.codegen.model.intermediate.ListModel;
import com.amazonaws.codegen.model.intermediate.MapModel;
import com.amazonaws.codegen.model.intermediate.MemberModel;
import com.amazonaws.codegen.model.intermediate.ParameterHttpMapping;
import com.amazonaws.codegen.model.intermediate.Protocol;
import com.amazonaws.codegen.model.intermediate.ReturnTypeModel;
import com.amazonaws.codegen.model.intermediate.ShapeModel;
import com.amazonaws.codegen.model.intermediate.VariableModel;
import com.amazonaws.codegen.model.service.Member;
import com.amazonaws.codegen.model.service.ServiceModel;
import com.amazonaws.codegen.model.service.Shape;
import com.amazonaws.util.StringUtils;
import java.util.List;
import java.util.Map;

abstract class AddShapes {
    private final ServiceModel serviceModel;
    private final CustomizationConfig customConfig;

    AddShapes(ServiceModel serviceModel, CustomizationConfig customizationConfig) {
        this.serviceModel = serviceModel;
        this.customConfig = customizationConfig;
    }

    protected final ServiceModel getServiceModel() {
        return this.serviceModel;
    }

    protected final CustomizationConfig getCustomizationConfig() {
        return this.customConfig;
    }

    protected final ShapeModel generateShapeModel(String javaClassName, String shapeName) {
        List<String> enumValues;
        ShapeModel shapeModel = new ShapeModel(shapeName);
        shapeModel.setShapeName(javaClassName);
        Shape shape = this.serviceModel.getShapes().get(shapeName);
        shapeModel.setDocumentation(shape.getDocumentation());
        shapeModel.setVariable(new VariableModel(NameUtils.getVariableName(javaClassName), javaClassName));
        shapeModel.setRequired(shape.getRequired());
        shapeModel.setDeprecated(shape.isDeprecated());
        boolean hasHeaderMember = false;
        boolean hasStatusCodeMember = false;
        boolean hasPayloadMember = false;
        boolean hasStreamingMember = false;
        Map<String, Member> members = shape.getMembers();
        if (members != null) {
            for (Map.Entry<String, Member> memberEntry : members.entrySet()) {
                String c2jMemberName = memberEntry.getKey();
                Member c2jMemberDefinition = memberEntry.getValue();
                Shape parentShape = shape;
                MemberModel memberModel = this.generateMemberModel(c2jMemberName, c2jMemberDefinition, this.getProtocol(), parentShape, this.serviceModel.getShapes());
                if (memberModel.getHttp().getLocation() == ParameterHttpMapping.Location.HEADER) {
                    hasHeaderMember = true;
                } else if (memberModel.getHttp().getLocation() == ParameterHttpMapping.Location.STATUS_CODE) {
                    hasStatusCodeMember = true;
                } else if (memberModel.getHttp().getIsPayload()) {
                    hasPayloadMember = true;
                    if (memberModel.getHttp().getIsStreaming()) {
                        hasStreamingMember = true;
                    }
                }
                shapeModel.addMember(memberModel);
            }
            shapeModel.withHasHeaderMember(hasHeaderMember).withHasStatusCodeMember(hasStatusCodeMember).withHasPayloadMember(hasPayloadMember).withHasStreamingMember(hasStreamingMember);
        }
        if ((enumValues = shape.getEnumValues()) != null && !enumValues.isEmpty()) {
            for (String enumValue : enumValues) {
                shapeModel.addEnum(new EnumModel(NameUtils.getEnumName(enumValue), enumValue));
            }
        }
        return shapeModel;
    }

    private MemberModel generateMemberModel(String c2jMemberName, Member c2jMemberDefinition, String protocol, Shape parentShape, Map<String, Shape> allC2jShapes) {
        String c2jShapeName = c2jMemberDefinition.getShape();
        String variableName = NameUtils.getVariableName(c2jMemberName);
        String variableType = TypeUtils.getJavaDataType(allC2jShapes, c2jShapeName);
        String variableDeclarationType = TypeUtils.getJavaDataType(allC2jShapes, c2jShapeName, this.customConfig);
        MemberModel memberModel = new MemberModel();
        memberModel.withC2jName(c2jMemberName).withC2jShape(c2jShapeName).withName(Utils.capitialize(c2jMemberName)).withVariable(new VariableModel(variableName, variableType, variableDeclarationType).withDocumentation(c2jMemberDefinition.getDocumentation())).withSetterModel(new VariableModel(variableName, variableType, variableDeclarationType).withDocumentation(DocumentationUtils.generateSetterDocumentation())).withGetterModel(new ReturnTypeModel(variableType).withDocumentation(DocumentationUtils.generateGetterDocumentation()));
        memberModel.setDocumentation(c2jMemberDefinition.getDocumentation());
        memberModel.setDeprecated(c2jMemberDefinition.isDeprecated());
        if (c2jMemberDefinition.getXmlNamespace() != null) {
            memberModel.setXmlNameSpaceUri(c2jMemberDefinition.getXmlNamespace().getUri());
        }
        this.fillContainerTypeMemberMetadata(allC2jShapes, c2jMemberDefinition.getShape(), memberModel, protocol);
        ParameterHttpMapping httpMapping = this.generateParameterHttpMapping(c2jMemberName, c2jMemberDefinition, protocol, allC2jShapes);
        String payload = parentShape.getPayload();
        httpMapping.withPayload(payload != null && payload.equals(c2jMemberName)).withStreaming(allC2jShapes.get(c2jMemberDefinition.getShape()).isStreaming());
        memberModel.setHttp(httpMapping);
        return memberModel;
    }

    private ParameterHttpMapping generateParameterHttpMapping(String memberName, Member member, String protocol, Map<String, Shape> allC2jShapes) {
        ParameterHttpMapping mapping = new ParameterHttpMapping();
        Shape memberShape = allC2jShapes.get(member.getShape());
        mapping.withLocation(ParameterHttpMapping.Location.forValue(member.getLocation())).withPayload(member.isPayload()).withStreaming(member.isStreaming()).withFlattened(member.isFlattened() || memberShape.isFlattened()).withUnmarshallLocationName(this.deriveUnmarshallerLocationName(memberName, member)).withMarshallLocationName(this.deriveMarshallerLocationName(memberName, member, protocol));
        return mapping;
    }

    private String deriveUnmarshallerLocationName(String memberName, Member member) {
        String locationName = member.getLocationName();
        if (locationName != null && !locationName.trim().isEmpty()) {
            return locationName;
        }
        return memberName;
    }

    private String deriveMarshallerLocationName(String memberName, Member member, String protocol) {
        String queryName = member.getQueryName();
        if (queryName != null && !queryName.trim().isEmpty()) {
            return queryName;
        }
        String locationName = member.getLocationName();
        if (locationName != null && !locationName.trim().isEmpty()) {
            if (protocol.equals(Protocol.EC2.getValue())) {
                return StringUtils.upperCase((String)locationName.substring(0, 1)) + locationName.substring(1);
            }
            return locationName;
        }
        return memberName;
    }

    private void fillContainerTypeMemberMetadata(Map<String, Shape> c2jShapes, String memberC2jShapeName, MemberModel memberModel, String protocol) {
        Shape memberC2jShape = c2jShapes.get(memberC2jShapeName);
        if (Utils.isListShape(memberC2jShape)) {
            MemberModel listMemberModel = null;
            Member listMemberDefinition = memberC2jShape.getListMember();
            String listMemberC2jShapeName = listMemberDefinition.getShape();
            Shape listMemberC2jShape = c2jShapes.get(listMemberC2jShapeName);
            if (!Utils.isScalar(listMemberC2jShape) || Utils.isEnumShape(listMemberC2jShape)) {
                listMemberModel = this.generateMemberModel("member", listMemberDefinition, protocol, memberC2jShape, c2jShapes);
            }
            String listImpl = this.customConfig.isUseAutoConstructList() ? TypeUtils.getDataTypeMapping("listAutoConstructImpl") : TypeUtils.getDataTypeMapping("listDefaultImpl");
            memberModel.setListModel(new ListModel(TypeUtils.getJavaDataType(c2jShapes, listMemberC2jShapeName), memberC2jShape.getListMember().getLocationName(), listImpl, TypeUtils.getDataTypeMapping("listInterface"), listMemberModel));
            if (listMemberC2jShape.getEnumValues() != null) {
                memberModel.setEnumType(NameUtils.getJavaClassName(listMemberC2jShapeName));
            }
        } else if (Utils.isMapShape(memberC2jShape)) {
            MemberModel mapKeyModel = null;
            MemberModel mapValueModel = null;
            Member mapKeyMemberDefinition = memberC2jShape.getMapKeyType();
            String mapKeyShapeName = mapKeyMemberDefinition.getShape();
            Shape mapKeyShape = c2jShapes.get(mapKeyShapeName);
            Member mapValueMemberDefinition = memberC2jShape.getMapValueType();
            String mapValueShapeName = mapValueMemberDefinition.getShape();
            Shape mapValueShape = c2jShapes.get(mapValueShapeName);
            if (Utils.isEnumShape(mapKeyShape)) {
                mapKeyModel = this.generateMemberModel("key", mapKeyMemberDefinition, protocol, memberC2jShape, c2jShapes);
            } else if (!Utils.isScalar(mapKeyShape)) {
                throw new IllegalStateException("The key type of " + mapKeyShapeName + " must be a scalar!");
            }
            if (!Utils.isScalar(mapValueShape) || Utils.isEnumShape(mapValueShape)) {
                mapValueModel = this.generateMemberModel("value", mapValueMemberDefinition, protocol, memberC2jShape, c2jShapes);
            }
            String mapImpl = this.customConfig.isUseAutoConstructMap() ? TypeUtils.getDataTypeMapping("mapAutoConstructImpl") : TypeUtils.getDataTypeMapping("mapDefaultImpl");
            String keyLocation = memberC2jShape.getMapKeyType().getLocationName() != null ? memberC2jShape.getMapKeyType().getLocationName() : "key";
            String valueLocation = memberC2jShape.getMapValueType().getLocationName() != null ? memberC2jShape.getMapValueType().getLocationName() : "value";
            memberModel.setMapModel(new MapModel(mapImpl, TypeUtils.getDataTypeMapping("mapInterface"), TypeUtils.getJavaDataType(c2jShapes, memberC2jShape.getMapKeyType().getShape()), keyLocation, mapKeyModel, TypeUtils.getJavaDataType(c2jShapes, memberC2jShape.getMapValueType().getShape()), valueLocation, mapValueModel));
        } else if (memberC2jShape.getEnumValues() != null) {
            memberModel.withEnumType(NameUtils.getJavaClassName(memberC2jShapeName));
        }
    }

    protected String getProtocol() {
        return this.getServiceModel().getMetadata().getProtocol();
    }
}

