/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cloudwatchrum;

import javax.annotation.Generated;

import com.amazonaws.services.cloudwatchrum.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSCloudWatchRUM}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSCloudWatchRUM implements AWSCloudWatchRUM {

    protected AbstractAWSCloudWatchRUM() {
    }

    @Override
    public BatchCreateRumMetricDefinitionsResult batchCreateRumMetricDefinitions(BatchCreateRumMetricDefinitionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchDeleteRumMetricDefinitionsResult batchDeleteRumMetricDefinitions(BatchDeleteRumMetricDefinitionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchGetRumMetricDefinitionsResult batchGetRumMetricDefinitions(BatchGetRumMetricDefinitionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAppMonitorResult createAppMonitor(CreateAppMonitorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAppMonitorResult deleteAppMonitor(DeleteAppMonitorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRumMetricsDestinationResult deleteRumMetricsDestination(DeleteRumMetricsDestinationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAppMonitorResult getAppMonitor(GetAppMonitorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAppMonitorDataResult getAppMonitorData(GetAppMonitorDataRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAppMonitorsResult listAppMonitors(ListAppMonitorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRumMetricsDestinationsResult listRumMetricsDestinations(ListRumMetricsDestinationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutRumEventsResult putRumEvents(PutRumEventsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutRumMetricsDestinationResult putRumMetricsDestination(PutRumMetricsDestinationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAppMonitorResult updateAppMonitor(UpdateAppMonitorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRumMetricDefinitionResult updateRumMetricDefinition(UpdateRumMetricDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
