/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudwatch.model.EntityMetricData;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class PutMetricDataRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String namespace;
    private SdkInternalList<MetricDatum> metricData;
    private SdkInternalList<EntityMetricData> entityMetricData;
    private Boolean strictEntityValidation;

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public PutMetricDataRequest withNamespace(String namespace) {
        this.setNamespace(namespace);
        return this;
    }

    public List<MetricDatum> getMetricData() {
        if (this.metricData == null) {
            this.metricData = new SdkInternalList();
        }
        return this.metricData;
    }

    public void setMetricData(Collection<MetricDatum> metricData) {
        if (metricData == null) {
            this.metricData = null;
            return;
        }
        this.metricData = new SdkInternalList(metricData);
    }

    public PutMetricDataRequest withMetricData(MetricDatum ... metricData) {
        if (this.metricData == null) {
            this.setMetricData((Collection<MetricDatum>)new SdkInternalList(metricData.length));
        }
        for (MetricDatum ele : metricData) {
            this.metricData.add((Object)ele);
        }
        return this;
    }

    public PutMetricDataRequest withMetricData(Collection<MetricDatum> metricData) {
        this.setMetricData(metricData);
        return this;
    }

    public List<EntityMetricData> getEntityMetricData() {
        if (this.entityMetricData == null) {
            this.entityMetricData = new SdkInternalList();
        }
        return this.entityMetricData;
    }

    public void setEntityMetricData(Collection<EntityMetricData> entityMetricData) {
        if (entityMetricData == null) {
            this.entityMetricData = null;
            return;
        }
        this.entityMetricData = new SdkInternalList(entityMetricData);
    }

    public PutMetricDataRequest withEntityMetricData(EntityMetricData ... entityMetricData) {
        if (this.entityMetricData == null) {
            this.setEntityMetricData((Collection<EntityMetricData>)new SdkInternalList(entityMetricData.length));
        }
        for (EntityMetricData ele : entityMetricData) {
            this.entityMetricData.add((Object)ele);
        }
        return this;
    }

    public PutMetricDataRequest withEntityMetricData(Collection<EntityMetricData> entityMetricData) {
        this.setEntityMetricData(entityMetricData);
        return this;
    }

    public void setStrictEntityValidation(Boolean strictEntityValidation) {
        this.strictEntityValidation = strictEntityValidation;
    }

    public Boolean getStrictEntityValidation() {
        return this.strictEntityValidation;
    }

    public PutMetricDataRequest withStrictEntityValidation(Boolean strictEntityValidation) {
        this.setStrictEntityValidation(strictEntityValidation);
        return this;
    }

    public Boolean isStrictEntityValidation() {
        return this.strictEntityValidation;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNamespace() != null) {
            sb.append("Namespace: ").append(this.getNamespace()).append(",");
        }
        if (this.getMetricData() != null) {
            sb.append("MetricData: ").append(this.getMetricData()).append(",");
        }
        if (this.getEntityMetricData() != null) {
            sb.append("EntityMetricData: ").append(this.getEntityMetricData()).append(",");
        }
        if (this.getStrictEntityValidation() != null) {
            sb.append("StrictEntityValidation: ").append(this.getStrictEntityValidation());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMetricDataRequest)) {
            return false;
        }
        PutMetricDataRequest other = (PutMetricDataRequest)obj;
        if (other.getNamespace() == null ^ this.getNamespace() == null) {
            return false;
        }
        if (other.getNamespace() != null && !other.getNamespace().equals(this.getNamespace())) {
            return false;
        }
        if (other.getMetricData() == null ^ this.getMetricData() == null) {
            return false;
        }
        if (other.getMetricData() != null && !other.getMetricData().equals(this.getMetricData())) {
            return false;
        }
        if (other.getEntityMetricData() == null ^ this.getEntityMetricData() == null) {
            return false;
        }
        if (other.getEntityMetricData() != null && !other.getEntityMetricData().equals(this.getEntityMetricData())) {
            return false;
        }
        if (other.getStrictEntityValidation() == null ^ this.getStrictEntityValidation() == null) {
            return false;
        }
        return other.getStrictEntityValidation() == null || other.getStrictEntityValidation().equals(this.getStrictEntityValidation());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getMetricData() == null ? 0 : this.getMetricData().hashCode());
        hashCode = 31 * hashCode + (this.getEntityMetricData() == null ? 0 : this.getEntityMetricData().hashCode());
        hashCode = 31 * hashCode + (this.getStrictEntityValidation() == null ? 0 : this.getStrictEntityValidation().hashCode());
        return hashCode;
    }

    public PutMetricDataRequest clone() {
        return (PutMetricDataRequest)super.clone();
    }
}

