/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cloudwatch.model.Entity;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.transform.EntityMetricDataMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class EntityMetricData
implements Serializable,
Cloneable,
StructuredPojo {
    private Entity entity;
    private SdkInternalList<MetricDatum> metricData;

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public EntityMetricData withEntity(Entity entity) {
        this.setEntity(entity);
        return this;
    }

    public List<MetricDatum> getMetricData() {
        if (this.metricData == null) {
            this.metricData = new SdkInternalList();
        }
        return this.metricData;
    }

    public void setMetricData(Collection<MetricDatum> metricData) {
        if (metricData == null) {
            this.metricData = null;
            return;
        }
        this.metricData = new SdkInternalList(metricData);
    }

    public EntityMetricData withMetricData(MetricDatum ... metricData) {
        if (this.metricData == null) {
            this.setMetricData((Collection<MetricDatum>)new SdkInternalList(metricData.length));
        }
        for (MetricDatum ele : metricData) {
            this.metricData.add((Object)ele);
        }
        return this;
    }

    public EntityMetricData withMetricData(Collection<MetricDatum> metricData) {
        this.setMetricData(metricData);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEntity() != null) {
            sb.append("Entity: ").append(this.getEntity()).append(",");
        }
        if (this.getMetricData() != null) {
            sb.append("MetricData: ").append(this.getMetricData());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityMetricData)) {
            return false;
        }
        EntityMetricData other = (EntityMetricData)obj;
        if (other.getEntity() == null ^ this.getEntity() == null) {
            return false;
        }
        if (other.getEntity() != null && !other.getEntity().equals(this.getEntity())) {
            return false;
        }
        if (other.getMetricData() == null ^ this.getMetricData() == null) {
            return false;
        }
        return other.getMetricData() == null || other.getMetricData().equals(this.getMetricData());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEntity() == null ? 0 : this.getEntity().hashCode());
        hashCode = 31 * hashCode + (this.getMetricData() == null ? 0 : this.getMetricData().hashCode());
        return hashCode;
    }

    public EntityMetricData clone() {
        try {
            return (EntityMetricData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EntityMetricDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

