/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class MetricDatumMarshaller {
    private static final MarshallingInfo<String> METRICNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MetricName").build();
    private static final MarshallingInfo<List> DIMENSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Dimensions").build();
    private static final MarshallingInfo<Date> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Double> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").build();
    private static final MarshallingInfo<StructuredPojo> STATISTICVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatisticValues").build();
    private static final MarshallingInfo<List> VALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Values").build();
    private static final MarshallingInfo<List> COUNTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Counts").build();
    private static final MarshallingInfo<String> UNIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Unit").build();
    private static final MarshallingInfo<Integer> STORAGERESOLUTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StorageResolution").build();
    private static final MetricDatumMarshaller instance = new MetricDatumMarshaller();

    public static MetricDatumMarshaller getInstance() {
        return instance;
    }

    public void marshall(MetricDatum metricDatum, ProtocolMarshaller protocolMarshaller) {
        if (metricDatum == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)metricDatum.getMetricName(), METRICNAME_BINDING);
            if (metricDatum.getDimensions() != null && !metricDatum.getDimensions().isEmpty()) {
                protocolMarshaller.marshall(metricDatum.getDimensions(), DIMENSIONS_BINDING);
            }
            protocolMarshaller.marshall((Object)metricDatum.getTimestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)metricDatum.getValue(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)metricDatum.getStatisticValues(), STATISTICVALUES_BINDING);
            if (metricDatum.getValues() != null && !metricDatum.getValues().isEmpty()) {
                protocolMarshaller.marshall(metricDatum.getValues(), VALUES_BINDING);
            }
            if (metricDatum.getCounts() != null && !metricDatum.getCounts().isEmpty()) {
                protocolMarshaller.marshall(metricDatum.getCounts(), COUNTS_BINDING);
            }
            protocolMarshaller.marshall((Object)metricDatum.getUnit(), UNIT_BINDING);
            protocolMarshaller.marshall((Object)metricDatum.getStorageResolution(), STORAGERESOLUTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request: " + e.getMessage(), (Throwable)e);
        }
    }
}

