/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.services.cloudwatch.model.Datapoint;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.transform.rpcv2cbor.MapUnmarshaller;
import com.amazonaws.transform.rpcv2cbor.RpcV2CborUnmarshallerContext;
import com.amazonaws.transform.rpcv2cbor.SimpleTypeRpcV2CborUnmarshallers;
import com.fasterxml.jackson.core.JsonToken;

public class DatapointRpcV2CborUnmarshaller
implements Unmarshaller<Datapoint, RpcV2CborUnmarshallerContext> {
    private static DatapointRpcV2CborUnmarshaller instance;

    public Datapoint unmarshall(RpcV2CborUnmarshallerContext context) throws Exception {
        Datapoint datapoint = new Datapoint();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Timestamp", targetDepth)) {
                    context.nextToken();
                    datapoint.setTimestamp(SimpleTypeRpcV2CborUnmarshallers.DateCborUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("SampleCount", targetDepth)) {
                    context.nextToken();
                    datapoint.setSampleCount((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("Average", targetDepth)) {
                    context.nextToken();
                    datapoint.setAverage((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("Sum", targetDepth)) {
                    context.nextToken();
                    datapoint.setSum((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("Minimum", targetDepth)) {
                    context.nextToken();
                    datapoint.setMinimum((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("Maximum", targetDepth)) {
                    context.nextToken();
                    datapoint.setMaximum((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("Unit", targetDepth)) {
                    context.nextToken();
                    datapoint.setUnit((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ExtendedStatistics", targetDepth)) {
                    context.nextToken();
                    datapoint.setExtendedStatistics(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(Double.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return datapoint;
    }

    public static DatapointRpcV2CborUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DatapointRpcV2CborUnmarshaller();
        }
        return instance;
    }
}

