/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.cloudwatch.model.MetricStreamFilter;
import java.util.List;

@SdkInternalApi
public class MetricStreamFilterMarshaller {
    private static final MarshallingInfo<String> NAMESPACE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Namespace").build();
    private static final MarshallingInfo<List> METRICNAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MetricNames").build();
    private static final MetricStreamFilterMarshaller instance = new MetricStreamFilterMarshaller();

    public static MetricStreamFilterMarshaller getInstance() {
        return instance;
    }

    public void marshall(MetricStreamFilter metricStreamFilter, ProtocolMarshaller protocolMarshaller) {
        if (metricStreamFilter == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)metricStreamFilter.getNamespace(), NAMESPACE_BINDING);
            if (metricStreamFilter.getMetricNames() != null && !metricStreamFilter.getMetricNames().isEmpty()) {
                protocolMarshaller.marshall(metricStreamFilter.getMetricNames(), METRICNAMES_BINDING);
            }
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request: " + e.getMessage(), (Throwable)e);
        }
    }
}

