/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.cloudwatch.model.MetricDataResult;
import java.util.List;

@SdkInternalApi
public class MetricDataResultMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<String> LABEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Label").build();
    private static final MarshallingInfo<List> TIMESTAMPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timestamps").build();
    private static final MarshallingInfo<List> VALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Values").build();
    private static final MarshallingInfo<String> STATUSCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusCode").build();
    private static final MarshallingInfo<List> MESSAGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Messages").build();
    private static final MetricDataResultMarshaller instance = new MetricDataResultMarshaller();

    public static MetricDataResultMarshaller getInstance() {
        return instance;
    }

    public void marshall(MetricDataResult metricDataResult, ProtocolMarshaller protocolMarshaller) {
        if (metricDataResult == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)metricDataResult.getId(), ID_BINDING);
            protocolMarshaller.marshall((Object)metricDataResult.getLabel(), LABEL_BINDING);
            if (metricDataResult.getTimestamps() != null && !metricDataResult.getTimestamps().isEmpty()) {
                protocolMarshaller.marshall(metricDataResult.getTimestamps(), TIMESTAMPS_BINDING);
            }
            if (metricDataResult.getValues() != null && !metricDataResult.getValues().isEmpty()) {
                protocolMarshaller.marshall(metricDataResult.getValues(), VALUES_BINDING);
            }
            protocolMarshaller.marshall((Object)metricDataResult.getStatusCode(), STATUSCODE_BINDING);
            if (metricDataResult.getMessages() != null && !metricDataResult.getMessages().isEmpty()) {
                protocolMarshaller.marshall(metricDataResult.getMessages(), MESSAGES_BINDING);
            }
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request: " + e.getMessage(), (Throwable)e);
        }
    }
}

