/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudwatch.model.DeleteAnomalyDetectorRequest;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.Metric;
import com.amazonaws.services.cloudwatch.model.MetricDataQuery;
import com.amazonaws.services.cloudwatch.model.MetricMathAnomalyDetector;
import com.amazonaws.services.cloudwatch.model.MetricStat;
import com.amazonaws.services.cloudwatch.model.SingleMetricAnomalyDetector;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteAnomalyDetectorRequestMarshaller
implements Marshaller<Request<DeleteAnomalyDetectorRequest>, DeleteAnomalyDetectorRequest> {
    public Request<DeleteAnomalyDetectorRequest> marshall(DeleteAnomalyDetectorRequest deleteAnomalyDetectorRequest) {
        MetricMathAnomalyDetector metricMathAnomalyDetector;
        SingleMetricAnomalyDetector singleMetricAnomalyDetector;
        if (deleteAnomalyDetectorRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteAnomalyDetectorRequest, "AmazonCloudWatch");
        request.addParameter("Action", "DeleteAnomalyDetector");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteAnomalyDetectorRequest.getNamespace() != null) {
            request.addParameter("Namespace", StringUtils.fromString((String)deleteAnomalyDetectorRequest.getNamespace()));
        }
        if (deleteAnomalyDetectorRequest.getMetricName() != null) {
            request.addParameter("MetricName", StringUtils.fromString((String)deleteAnomalyDetectorRequest.getMetricName()));
        }
        if (!deleteAnomalyDetectorRequest.getDimensions().isEmpty() || !((SdkInternalList)deleteAnomalyDetectorRequest.getDimensions()).isAutoConstruct()) {
            SdkInternalList dimensionsList = (SdkInternalList)deleteAnomalyDetectorRequest.getDimensions();
            int dimensionsListIndex = 1;
            for (Dimension dimensionsListValue : dimensionsList) {
                if (dimensionsListValue != null) {
                    if (dimensionsListValue.getName() != null) {
                        request.addParameter("Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString((String)dimensionsListValue.getName()));
                    }
                    if (dimensionsListValue.getValue() != null) {
                        request.addParameter("Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString((String)dimensionsListValue.getValue()));
                    }
                }
                ++dimensionsListIndex;
            }
        }
        if (deleteAnomalyDetectorRequest.getStat() != null) {
            request.addParameter("Stat", StringUtils.fromString((String)deleteAnomalyDetectorRequest.getStat()));
        }
        if ((singleMetricAnomalyDetector = deleteAnomalyDetectorRequest.getSingleMetricAnomalyDetector()) != null) {
            if (singleMetricAnomalyDetector.getAccountId() != null) {
                request.addParameter("SingleMetricAnomalyDetector.AccountId", StringUtils.fromString((String)singleMetricAnomalyDetector.getAccountId()));
            }
            if (singleMetricAnomalyDetector.getNamespace() != null) {
                request.addParameter("SingleMetricAnomalyDetector.Namespace", StringUtils.fromString((String)singleMetricAnomalyDetector.getNamespace()));
            }
            if (singleMetricAnomalyDetector.getMetricName() != null) {
                request.addParameter("SingleMetricAnomalyDetector.MetricName", StringUtils.fromString((String)singleMetricAnomalyDetector.getMetricName()));
            }
            if (!singleMetricAnomalyDetector.getDimensions().isEmpty() || !((SdkInternalList)singleMetricAnomalyDetector.getDimensions()).isAutoConstruct()) {
                SdkInternalList dimensionsList = (SdkInternalList)singleMetricAnomalyDetector.getDimensions();
                int dimensionsListIndex = 1;
                for (Dimension dimensionsListValue : dimensionsList) {
                    if (dimensionsListValue != null) {
                        if (dimensionsListValue.getName() != null) {
                            request.addParameter("SingleMetricAnomalyDetector.Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString((String)dimensionsListValue.getName()));
                        }
                        if (dimensionsListValue.getValue() != null) {
                            request.addParameter("SingleMetricAnomalyDetector.Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString((String)dimensionsListValue.getValue()));
                        }
                    }
                    ++dimensionsListIndex;
                }
            }
            if (singleMetricAnomalyDetector.getStat() != null) {
                request.addParameter("SingleMetricAnomalyDetector.Stat", StringUtils.fromString((String)singleMetricAnomalyDetector.getStat()));
            }
        }
        if (!((metricMathAnomalyDetector = deleteAnomalyDetectorRequest.getMetricMathAnomalyDetector()) == null || metricMathAnomalyDetector.getMetricDataQueries().isEmpty() && ((SdkInternalList)metricMathAnomalyDetector.getMetricDataQueries()).isAutoConstruct())) {
            SdkInternalList metricDataQueriesList = (SdkInternalList)metricMathAnomalyDetector.getMetricDataQueries();
            int metricDataQueriesListIndex = 1;
            for (MetricDataQuery metricDataQueriesListValue : metricDataQueriesList) {
                if (metricDataQueriesListValue != null) {
                    MetricStat metricStat;
                    if (metricDataQueriesListValue.getId() != null) {
                        request.addParameter("MetricMathAnomalyDetector.MetricDataQueries.member." + metricDataQueriesListIndex + ".Id", StringUtils.fromString((String)metricDataQueriesListValue.getId()));
                    }
                    if ((metricStat = metricDataQueriesListValue.getMetricStat()) != null) {
                        Metric metric = metricStat.getMetric();
                        if (metric != null) {
                            if (metric.getNamespace() != null) {
                                request.addParameter("MetricMathAnomalyDetector.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.Namespace", StringUtils.fromString((String)metric.getNamespace()));
                            }
                            if (metric.getMetricName() != null) {
                                request.addParameter("MetricMathAnomalyDetector.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.MetricName", StringUtils.fromString((String)metric.getMetricName()));
                            }
                            if (!metric.getDimensions().isEmpty() || !((SdkInternalList)metric.getDimensions()).isAutoConstruct()) {
                                SdkInternalList dimensionsList = (SdkInternalList)metric.getDimensions();
                                int dimensionsListIndex = 1;
                                for (Dimension dimensionsListValue : dimensionsList) {
                                    if (dimensionsListValue != null) {
                                        if (dimensionsListValue.getName() != null) {
                                            request.addParameter("MetricMathAnomalyDetector.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString((String)dimensionsListValue.getName()));
                                        }
                                        if (dimensionsListValue.getValue() != null) {
                                            request.addParameter("MetricMathAnomalyDetector.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString((String)dimensionsListValue.getValue()));
                                        }
                                    }
                                    ++dimensionsListIndex;
                                }
                            }
                        }
                        if (metricStat.getPeriod() != null) {
                            request.addParameter("MetricMathAnomalyDetector.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Period", StringUtils.fromInteger((Integer)metricStat.getPeriod()));
                        }
                        if (metricStat.getStat() != null) {
                            request.addParameter("MetricMathAnomalyDetector.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Stat", StringUtils.fromString((String)metricStat.getStat()));
                        }
                        if (metricStat.getUnit() != null) {
                            request.addParameter("MetricMathAnomalyDetector.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Unit", StringUtils.fromString((String)metricStat.getUnit()));
                        }
                    }
                    if (metricDataQueriesListValue.getExpression() != null) {
                        request.addParameter("MetricMathAnomalyDetector.MetricDataQueries.member." + metricDataQueriesListIndex + ".Expression", StringUtils.fromString((String)metricDataQueriesListValue.getExpression()));
                    }
                    if (metricDataQueriesListValue.getLabel() != null) {
                        request.addParameter("MetricMathAnomalyDetector.MetricDataQueries.member." + metricDataQueriesListIndex + ".Label", StringUtils.fromString((String)metricDataQueriesListValue.getLabel()));
                    }
                    if (metricDataQueriesListValue.getReturnData() != null) {
                        request.addParameter("MetricMathAnomalyDetector.MetricDataQueries.member." + metricDataQueriesListIndex + ".ReturnData", StringUtils.fromBoolean((Boolean)metricDataQueriesListValue.getReturnData()));
                    }
                    if (metricDataQueriesListValue.getPeriod() != null) {
                        request.addParameter("MetricMathAnomalyDetector.MetricDataQueries.member." + metricDataQueriesListIndex + ".Period", StringUtils.fromInteger((Integer)metricDataQueriesListValue.getPeriod()));
                    }
                    if (metricDataQueriesListValue.getAccountId() != null) {
                        request.addParameter("MetricMathAnomalyDetector.MetricDataQueries.member." + metricDataQueriesListIndex + ".AccountId", StringUtils.fromString((String)metricDataQueriesListValue.getAccountId()));
                    }
                }
                ++metricDataQueriesListIndex;
            }
        }
        return request;
    }
}

