/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.services.cloudwatch.model.MetricStreamFilter;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class MetricStreamFilterStaxUnmarshaller
implements Unmarshaller<MetricStreamFilter, StaxUnmarshallerContext> {
    private static MetricStreamFilterStaxUnmarshaller instance;

    public MetricStreamFilter unmarshall(StaxUnmarshallerContext context) throws Exception {
        MetricStreamFilter metricStreamFilter = new MetricStreamFilter();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return metricStreamFilter;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Namespace", targetDepth)) {
                    metricStreamFilter.setNamespace(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MetricNames", targetDepth)) {
                    metricStreamFilter.withMetricNames(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("MetricNames/member", targetDepth)) continue;
                metricStreamFilter.withMetricNames(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return metricStreamFilter;
    }

    public static MetricStreamFilterStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MetricStreamFilterStaxUnmarshaller();
        }
        return instance;
    }
}

