/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class StartQueryRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String queryStatement;
    private String deliveryS3Uri;
    private String queryAlias;
    private SdkInternalList<String> queryParameters;

    public void setQueryStatement(String queryStatement) {
        this.queryStatement = queryStatement;
    }

    public String getQueryStatement() {
        return this.queryStatement;
    }

    public StartQueryRequest withQueryStatement(String queryStatement) {
        this.setQueryStatement(queryStatement);
        return this;
    }

    public void setDeliveryS3Uri(String deliveryS3Uri) {
        this.deliveryS3Uri = deliveryS3Uri;
    }

    public String getDeliveryS3Uri() {
        return this.deliveryS3Uri;
    }

    public StartQueryRequest withDeliveryS3Uri(String deliveryS3Uri) {
        this.setDeliveryS3Uri(deliveryS3Uri);
        return this;
    }

    public void setQueryAlias(String queryAlias) {
        this.queryAlias = queryAlias;
    }

    public String getQueryAlias() {
        return this.queryAlias;
    }

    public StartQueryRequest withQueryAlias(String queryAlias) {
        this.setQueryAlias(queryAlias);
        return this;
    }

    public List<String> getQueryParameters() {
        if (this.queryParameters == null) {
            this.queryParameters = new SdkInternalList();
        }
        return this.queryParameters;
    }

    public void setQueryParameters(Collection<String> queryParameters) {
        if (queryParameters == null) {
            this.queryParameters = null;
            return;
        }
        this.queryParameters = new SdkInternalList(queryParameters);
    }

    public StartQueryRequest withQueryParameters(String ... queryParameters) {
        if (this.queryParameters == null) {
            this.setQueryParameters((Collection<String>)new SdkInternalList(queryParameters.length));
        }
        for (String ele : queryParameters) {
            this.queryParameters.add((Object)ele);
        }
        return this;
    }

    public StartQueryRequest withQueryParameters(Collection<String> queryParameters) {
        this.setQueryParameters(queryParameters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQueryStatement() != null) {
            sb.append("QueryStatement: ").append(this.getQueryStatement()).append(",");
        }
        if (this.getDeliveryS3Uri() != null) {
            sb.append("DeliveryS3Uri: ").append(this.getDeliveryS3Uri()).append(",");
        }
        if (this.getQueryAlias() != null) {
            sb.append("QueryAlias: ").append(this.getQueryAlias()).append(",");
        }
        if (this.getQueryParameters() != null) {
            sb.append("QueryParameters: ").append(this.getQueryParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartQueryRequest)) {
            return false;
        }
        StartQueryRequest other = (StartQueryRequest)obj;
        if (other.getQueryStatement() == null ^ this.getQueryStatement() == null) {
            return false;
        }
        if (other.getQueryStatement() != null && !other.getQueryStatement().equals(this.getQueryStatement())) {
            return false;
        }
        if (other.getDeliveryS3Uri() == null ^ this.getDeliveryS3Uri() == null) {
            return false;
        }
        if (other.getDeliveryS3Uri() != null && !other.getDeliveryS3Uri().equals(this.getDeliveryS3Uri())) {
            return false;
        }
        if (other.getQueryAlias() == null ^ this.getQueryAlias() == null) {
            return false;
        }
        if (other.getQueryAlias() != null && !other.getQueryAlias().equals(this.getQueryAlias())) {
            return false;
        }
        if (other.getQueryParameters() == null ^ this.getQueryParameters() == null) {
            return false;
        }
        return other.getQueryParameters() == null || other.getQueryParameters().equals(this.getQueryParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQueryStatement() == null ? 0 : this.getQueryStatement().hashCode());
        hashCode = 31 * hashCode + (this.getDeliveryS3Uri() == null ? 0 : this.getDeliveryS3Uri().hashCode());
        hashCode = 31 * hashCode + (this.getQueryAlias() == null ? 0 : this.getQueryAlias().hashCode());
        hashCode = 31 * hashCode + (this.getQueryParameters() == null ? 0 : this.getQueryParameters().hashCode());
        return hashCode;
    }

    public StartQueryRequest clone() {
        return (StartQueryRequest)super.clone();
    }
}

