/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudtrail.model.TrailInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListTrailsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<TrailInfo> trails;
    private String nextToken;

    public List<TrailInfo> getTrails() {
        if (this.trails == null) {
            this.trails = new SdkInternalList();
        }
        return this.trails;
    }

    public void setTrails(Collection<TrailInfo> trails) {
        if (trails == null) {
            this.trails = null;
            return;
        }
        this.trails = new SdkInternalList(trails);
    }

    public ListTrailsResult withTrails(TrailInfo ... trails) {
        if (this.trails == null) {
            this.setTrails((Collection<TrailInfo>)new SdkInternalList(trails.length));
        }
        for (TrailInfo ele : trails) {
            this.trails.add((Object)ele);
        }
        return this;
    }

    public ListTrailsResult withTrails(Collection<TrailInfo> trails) {
        this.setTrails(trails);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListTrailsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTrails() != null) {
            sb.append("Trails: ").append(this.getTrails()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrailsResult)) {
            return false;
        }
        ListTrailsResult other = (ListTrailsResult)obj;
        if (other.getTrails() == null ^ this.getTrails() == null) {
            return false;
        }
        if (other.getTrails() != null && !other.getTrails().equals(this.getTrails())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTrails() == null ? 0 : this.getTrails().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListTrailsResult clone() {
        try {
            return (ListTrailsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

