/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.services.cloudtrail.model.ImportSource;
import com.amazonaws.services.cloudtrail.model.transform.S3ImportSourceJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class ImportSourceJsonUnmarshaller
implements Unmarshaller<ImportSource, JsonUnmarshallerContext> {
    private static ImportSourceJsonUnmarshaller instance;

    public ImportSource unmarshall(JsonUnmarshallerContext context) throws Exception {
        ImportSource importSource = new ImportSource();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("S3", targetDepth)) {
                    context.nextToken();
                    importSource.setS3(S3ImportSourceJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return importSource;
    }

    public static ImportSourceJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ImportSourceJsonUnmarshaller();
        }
        return instance;
    }
}

