/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.cloudtrail.AWSCloudTrail;
import com.amazonaws.services.cloudtrail.AWSCloudTrailClientBuilder;
import com.amazonaws.services.cloudtrail.model.AWSCloudTrailException;
import com.amazonaws.services.cloudtrail.model.AddTagsRequest;
import com.amazonaws.services.cloudtrail.model.AddTagsResult;
import com.amazonaws.services.cloudtrail.model.CreateTrailRequest;
import com.amazonaws.services.cloudtrail.model.CreateTrailResult;
import com.amazonaws.services.cloudtrail.model.DeleteTrailRequest;
import com.amazonaws.services.cloudtrail.model.DeleteTrailResult;
import com.amazonaws.services.cloudtrail.model.DescribeTrailsRequest;
import com.amazonaws.services.cloudtrail.model.DescribeTrailsResult;
import com.amazonaws.services.cloudtrail.model.GetEventSelectorsRequest;
import com.amazonaws.services.cloudtrail.model.GetEventSelectorsResult;
import com.amazonaws.services.cloudtrail.model.GetTrailStatusRequest;
import com.amazonaws.services.cloudtrail.model.GetTrailStatusResult;
import com.amazonaws.services.cloudtrail.model.ListPublicKeysRequest;
import com.amazonaws.services.cloudtrail.model.ListPublicKeysResult;
import com.amazonaws.services.cloudtrail.model.ListTagsRequest;
import com.amazonaws.services.cloudtrail.model.ListTagsResult;
import com.amazonaws.services.cloudtrail.model.LookupEventsRequest;
import com.amazonaws.services.cloudtrail.model.LookupEventsResult;
import com.amazonaws.services.cloudtrail.model.PutEventSelectorsRequest;
import com.amazonaws.services.cloudtrail.model.PutEventSelectorsResult;
import com.amazonaws.services.cloudtrail.model.RemoveTagsRequest;
import com.amazonaws.services.cloudtrail.model.RemoveTagsResult;
import com.amazonaws.services.cloudtrail.model.StartLoggingRequest;
import com.amazonaws.services.cloudtrail.model.StartLoggingResult;
import com.amazonaws.services.cloudtrail.model.StopLoggingRequest;
import com.amazonaws.services.cloudtrail.model.StopLoggingResult;
import com.amazonaws.services.cloudtrail.model.UpdateTrailRequest;
import com.amazonaws.services.cloudtrail.model.UpdateTrailResult;
import com.amazonaws.services.cloudtrail.model.transform.AddTagsRequestProtocolMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.AddTagsResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.CloudTrailARNInvalidExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.CloudTrailAccessNotEnabledExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.CloudWatchLogsDeliveryUnavailableExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.CreateTrailRequestProtocolMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.CreateTrailResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.DeleteTrailRequestProtocolMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.DeleteTrailResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.DescribeTrailsRequestProtocolMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.DescribeTrailsResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.GetEventSelectorsRequestProtocolMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.GetEventSelectorsResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.GetTrailStatusRequestProtocolMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.GetTrailStatusResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InsufficientDependencyServiceAccessPermissionExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InsufficientEncryptionPolicyExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InsufficientS3BucketPolicyExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InsufficientSnsTopicPolicyExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InvalidCloudWatchLogsLogGroupArnExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InvalidCloudWatchLogsRoleArnExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InvalidEventSelectorsExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InvalidHomeRegionExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InvalidKmsKeyIdExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InvalidLookupAttributesExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InvalidMaxResultsExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InvalidNextTokenExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InvalidParameterCombinationExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InvalidS3BucketNameExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InvalidS3PrefixExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InvalidSnsTopicNameExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InvalidTagParameterExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InvalidTimeRangeExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InvalidTokenExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InvalidTrailNameExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.KmsExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.KmsKeyDisabledExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.KmsKeyNotFoundExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.ListPublicKeysRequestProtocolMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.ListPublicKeysResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.ListTagsRequestProtocolMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.ListTagsResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.LookupEventsRequestProtocolMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.LookupEventsResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.MaximumNumberOfTrailsExceededExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.NotOrganizationMasterAccountExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.OperationNotPermittedExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.OrganizationNotInAllFeaturesModeExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.OrganizationsNotInUseExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.PutEventSelectorsRequestProtocolMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.PutEventSelectorsResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.RemoveTagsRequestProtocolMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.RemoveTagsResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.ResourceTypeNotSupportedExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.S3BucketDoesNotExistExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.StartLoggingRequestProtocolMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.StartLoggingResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.StopLoggingRequestProtocolMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.StopLoggingResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.TagsLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.TrailAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.TrailNotFoundExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.TrailNotProvidedExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.UnsupportedOperationExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.UpdateTrailRequestProtocolMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.UpdateTrailResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSCloudTrailClient
extends AmazonWebServiceClient
implements AWSCloudTrail {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSCloudTrail.class);
    private static final String DEFAULT_SIGNING_NAME = "cloudtrail";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidTokenException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidTokenExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CloudTrailARNInvalidException").withExceptionUnmarshaller((JsonErrorUnmarshaller)CloudTrailARNInvalidExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InsufficientDependencyServiceAccessPermissionException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InsufficientDependencyServiceAccessPermissionExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidCloudWatchLogsRoleArnException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidCloudWatchLogsRoleArnExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidKmsKeyIdException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidKmsKeyIdExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidTimeRangeException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidTimeRangeExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidEventSelectorsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidEventSelectorsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedOperationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)UnsupportedOperationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TrailNotProvidedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)TrailNotProvidedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidCloudWatchLogsLogGroupArnException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidCloudWatchLogsLogGroupArnExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KmsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)KmsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OrganizationNotInAllFeaturesModeException").withExceptionUnmarshaller((JsonErrorUnmarshaller)OrganizationNotInAllFeaturesModeExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("S3BucketDoesNotExistException").withExceptionUnmarshaller((JsonErrorUnmarshaller)S3BucketDoesNotExistExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterCombinationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidParameterCombinationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidMaxResultsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidMaxResultsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TagsLimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)TagsLimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidS3BucketNameException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidS3BucketNameExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CloudWatchLogsDeliveryUnavailableException").withExceptionUnmarshaller((JsonErrorUnmarshaller)CloudWatchLogsDeliveryUnavailableExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CloudTrailAccessNotEnabledException").withExceptionUnmarshaller((JsonErrorUnmarshaller)CloudTrailAccessNotEnabledExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidTrailNameException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidTrailNameExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidSnsTopicNameException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidSnsTopicNameExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InsufficientEncryptionPolicyException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InsufficientEncryptionPolicyExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotOrganizationMasterAccountException").withExceptionUnmarshaller((JsonErrorUnmarshaller)NotOrganizationMasterAccountExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidTagParameterException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidTagParameterExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KmsKeyNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)KmsKeyNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OperationNotPermittedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)OperationNotPermittedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TrailNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)TrailNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidLookupAttributesException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidLookupAttributesExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MaximumNumberOfTrailsExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)MaximumNumberOfTrailsExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidS3PrefixException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidS3PrefixExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InsufficientSnsTopicPolicyException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InsufficientSnsTopicPolicyExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OrganizationsNotInUseException").withExceptionUnmarshaller((JsonErrorUnmarshaller)OrganizationsNotInUseExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidNextTokenExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InsufficientS3BucketPolicyException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InsufficientS3BucketPolicyExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidHomeRegionException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidHomeRegionExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceTypeNotSupportedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceTypeNotSupportedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TrailAlreadyExistsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)TrailAlreadyExistsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KmsKeyDisabledException").withExceptionUnmarshaller((JsonErrorUnmarshaller)KmsKeyDisabledExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSCloudTrailException.class));

    @Deprecated
    public AWSCloudTrailClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AWSCloudTrailClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AWSCloudTrailClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AWSCloudTrailClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    @Deprecated
    public AWSCloudTrailClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AWSCloudTrailClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AWSCloudTrailClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    public static AWSCloudTrailClientBuilder builder() {
        return AWSCloudTrailClientBuilder.standard();
    }

    AWSCloudTrailClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSCloudTrailClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("cloudtrail.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/cloudtrail/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/cloudtrail/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AddTagsResult addTags(AddTagsRequest request) {
        request = (AddTagsRequest)this.beforeClientExecution(request);
        return this.executeAddTags(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AddTagsResult executeAddTags(AddTagsRequest addTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddTagsRequestProtocolMarshaller(protocolFactory).marshall((AddTagsRequest)super.beforeMarshalling((AmazonWebServiceRequest)addTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudTrail");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AddTags");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AddTagsResult addTagsResult = (AddTagsResult)response.getAwsResponse();
            return addTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateTrailResult createTrail(CreateTrailRequest request) {
        request = (CreateTrailRequest)this.beforeClientExecution(request);
        return this.executeCreateTrail(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateTrailResult executeCreateTrail(CreateTrailRequest createTrailRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createTrailRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateTrailRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateTrailRequestProtocolMarshaller(protocolFactory).marshall((CreateTrailRequest)super.beforeMarshalling((AmazonWebServiceRequest)createTrailRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudTrail");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateTrail");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateTrailResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateTrailResult createTrailResult = (CreateTrailResult)response.getAwsResponse();
            return createTrailResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteTrailResult deleteTrail(DeleteTrailRequest request) {
        request = (DeleteTrailRequest)this.beforeClientExecution(request);
        return this.executeDeleteTrail(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteTrailResult executeDeleteTrail(DeleteTrailRequest deleteTrailRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteTrailRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteTrailRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteTrailRequestProtocolMarshaller(protocolFactory).marshall((DeleteTrailRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteTrailRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudTrail");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteTrail");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteTrailResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteTrailResult deleteTrailResult = (DeleteTrailResult)response.getAwsResponse();
            return deleteTrailResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeTrailsResult describeTrails(DescribeTrailsRequest request) {
        request = (DescribeTrailsRequest)this.beforeClientExecution(request);
        return this.executeDescribeTrails(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeTrailsResult executeDescribeTrails(DescribeTrailsRequest describeTrailsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeTrailsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeTrailsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeTrailsRequestProtocolMarshaller(protocolFactory).marshall((DescribeTrailsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeTrailsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudTrail");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeTrails");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeTrailsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeTrailsResult describeTrailsResult = (DescribeTrailsResult)response.getAwsResponse();
            return describeTrailsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeTrailsResult describeTrails() {
        return this.describeTrails(new DescribeTrailsRequest());
    }

    @Override
    public GetEventSelectorsResult getEventSelectors(GetEventSelectorsRequest request) {
        request = (GetEventSelectorsRequest)this.beforeClientExecution(request);
        return this.executeGetEventSelectors(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetEventSelectorsResult executeGetEventSelectors(GetEventSelectorsRequest getEventSelectorsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getEventSelectorsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetEventSelectorsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetEventSelectorsRequestProtocolMarshaller(protocolFactory).marshall((GetEventSelectorsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getEventSelectorsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudTrail");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetEventSelectors");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetEventSelectorsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetEventSelectorsResult getEventSelectorsResult = (GetEventSelectorsResult)response.getAwsResponse();
            return getEventSelectorsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetTrailStatusResult getTrailStatus(GetTrailStatusRequest request) {
        request = (GetTrailStatusRequest)this.beforeClientExecution(request);
        return this.executeGetTrailStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetTrailStatusResult executeGetTrailStatus(GetTrailStatusRequest getTrailStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTrailStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTrailStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTrailStatusRequestProtocolMarshaller(protocolFactory).marshall((GetTrailStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)getTrailStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudTrail");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetTrailStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTrailStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetTrailStatusResult getTrailStatusResult = (GetTrailStatusResult)response.getAwsResponse();
            return getTrailStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPublicKeysResult listPublicKeys(ListPublicKeysRequest request) {
        request = (ListPublicKeysRequest)this.beforeClientExecution(request);
        return this.executeListPublicKeys(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPublicKeysResult executeListPublicKeys(ListPublicKeysRequest listPublicKeysRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPublicKeysRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPublicKeysRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPublicKeysRequestProtocolMarshaller(protocolFactory).marshall((ListPublicKeysRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPublicKeysRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudTrail");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListPublicKeys");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPublicKeysResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPublicKeysResult listPublicKeysResult = (ListPublicKeysResult)response.getAwsResponse();
            return listPublicKeysResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPublicKeysResult listPublicKeys() {
        return this.listPublicKeys(new ListPublicKeysRequest());
    }

    @Override
    public ListTagsResult listTags(ListTagsRequest request) {
        request = (ListTagsRequest)this.beforeClientExecution(request);
        return this.executeListTags(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsResult executeListTags(ListTagsRequest listTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsRequestProtocolMarshaller(protocolFactory).marshall((ListTagsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudTrail");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTags");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsResult listTagsResult = (ListTagsResult)response.getAwsResponse();
            return listTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public LookupEventsResult lookupEvents(LookupEventsRequest request) {
        request = (LookupEventsRequest)this.beforeClientExecution(request);
        return this.executeLookupEvents(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final LookupEventsResult executeLookupEvents(LookupEventsRequest lookupEventsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(lookupEventsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<LookupEventsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new LookupEventsRequestProtocolMarshaller(protocolFactory).marshall((LookupEventsRequest)super.beforeMarshalling((AmazonWebServiceRequest)lookupEventsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudTrail");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"LookupEvents");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new LookupEventsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            LookupEventsResult lookupEventsResult = (LookupEventsResult)response.getAwsResponse();
            return lookupEventsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public LookupEventsResult lookupEvents() {
        return this.lookupEvents(new LookupEventsRequest());
    }

    @Override
    public PutEventSelectorsResult putEventSelectors(PutEventSelectorsRequest request) {
        request = (PutEventSelectorsRequest)this.beforeClientExecution(request);
        return this.executePutEventSelectors(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutEventSelectorsResult executePutEventSelectors(PutEventSelectorsRequest putEventSelectorsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putEventSelectorsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutEventSelectorsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutEventSelectorsRequestProtocolMarshaller(protocolFactory).marshall((PutEventSelectorsRequest)super.beforeMarshalling((AmazonWebServiceRequest)putEventSelectorsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudTrail");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutEventSelectors");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutEventSelectorsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutEventSelectorsResult putEventSelectorsResult = (PutEventSelectorsResult)response.getAwsResponse();
            return putEventSelectorsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RemoveTagsResult removeTags(RemoveTagsRequest request) {
        request = (RemoveTagsRequest)this.beforeClientExecution(request);
        return this.executeRemoveTags(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RemoveTagsResult executeRemoveTags(RemoveTagsRequest removeTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(removeTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RemoveTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RemoveTagsRequestProtocolMarshaller(protocolFactory).marshall((RemoveTagsRequest)super.beforeMarshalling((AmazonWebServiceRequest)removeTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudTrail");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RemoveTags");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RemoveTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RemoveTagsResult removeTagsResult = (RemoveTagsResult)response.getAwsResponse();
            return removeTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartLoggingResult startLogging(StartLoggingRequest request) {
        request = (StartLoggingRequest)this.beforeClientExecution(request);
        return this.executeStartLogging(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartLoggingResult executeStartLogging(StartLoggingRequest startLoggingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startLoggingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartLoggingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartLoggingRequestProtocolMarshaller(protocolFactory).marshall((StartLoggingRequest)super.beforeMarshalling((AmazonWebServiceRequest)startLoggingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudTrail");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartLogging");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartLoggingResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartLoggingResult startLoggingResult = (StartLoggingResult)response.getAwsResponse();
            return startLoggingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopLoggingResult stopLogging(StopLoggingRequest request) {
        request = (StopLoggingRequest)this.beforeClientExecution(request);
        return this.executeStopLogging(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopLoggingResult executeStopLogging(StopLoggingRequest stopLoggingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopLoggingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopLoggingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopLoggingRequestProtocolMarshaller(protocolFactory).marshall((StopLoggingRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopLoggingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudTrail");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopLogging");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopLoggingResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopLoggingResult stopLoggingResult = (StopLoggingResult)response.getAwsResponse();
            return stopLoggingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateTrailResult updateTrail(UpdateTrailRequest request) {
        request = (UpdateTrailRequest)this.beforeClientExecution(request);
        return this.executeUpdateTrail(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateTrailResult executeUpdateTrail(UpdateTrailRequest updateTrailRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateTrailRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateTrailRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateTrailRequestProtocolMarshaller(protocolFactory).marshall((UpdateTrailRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateTrailRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudTrail");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateTrail");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateTrailResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateTrailResult updateTrailResult = (UpdateTrailResult)response.getAwsResponse();
            return updateTrailResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

