/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.services.cloudtrail.model.PublicKey;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;
import java.nio.ByteBuffer;

public class PublicKeyJsonUnmarshaller
implements Unmarshaller<PublicKey, JsonUnmarshallerContext> {
    private static PublicKeyJsonUnmarshaller instance;

    public PublicKey unmarshall(JsonUnmarshallerContext context) throws Exception {
        PublicKey publicKey = new PublicKey();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Value", targetDepth)) {
                    context.nextToken();
                    publicKey.setValue((ByteBuffer)context.getUnmarshaller(ByteBuffer.class).unmarshall((Object)context));
                }
                if (context.testExpression("ValidityStartTime", targetDepth)) {
                    context.nextToken();
                    publicKey.setValidityStartTime(SimpleTypeJsonUnmarshallers.DateJsonUnmarshallerFactory.getInstance((String)"unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("ValidityEndTime", targetDepth)) {
                    context.nextToken();
                    publicKey.setValidityEndTime(SimpleTypeJsonUnmarshallers.DateJsonUnmarshallerFactory.getInstance((String)"unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("Fingerprint", targetDepth)) {
                    context.nextToken();
                    publicKey.setFingerprint((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return publicKey;
    }

    public static PublicKeyJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PublicKeyJsonUnmarshaller();
        }
        return instance;
    }
}

