/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudtrail.model.ResourceTag;
import com.amazonaws.services.cloudtrail.model.Tag;
import com.amazonaws.services.cloudtrail.model.transform.TagJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class ResourceTagJsonMarshaller {
    private static ResourceTagJsonMarshaller instance;

    public void marshall(ResourceTag resourceTag, JSONWriter jsonWriter) {
        if (resourceTag == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList tagsListList;
            jsonWriter.object();
            if (resourceTag.getResourceId() != null) {
                jsonWriter.key("ResourceId").value((Object)resourceTag.getResourceId());
            }
            if (!(tagsListList = (SdkInternalList)resourceTag.getTagsList()).isEmpty() || !tagsListList.isAutoConstruct()) {
                jsonWriter.key("TagsList");
                jsonWriter.array();
                for (Tag tagsListListValue : tagsListList) {
                    if (tagsListListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsListListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ResourceTagJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ResourceTagJsonMarshaller();
        }
        return instance;
    }
}

