/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudtrail.model.Event;
import com.amazonaws.services.cloudtrail.model.Resource;
import com.amazonaws.services.cloudtrail.model.transform.ResourceJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class EventJsonMarshaller {
    private static EventJsonMarshaller instance;

    public void marshall(Event event, JSONWriter jsonWriter) {
        if (event == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList resourcesList;
            jsonWriter.object();
            if (event.getEventId() != null) {
                jsonWriter.key("EventId").value((Object)event.getEventId());
            }
            if (event.getEventName() != null) {
                jsonWriter.key("EventName").value((Object)event.getEventName());
            }
            if (event.getEventTime() != null) {
                jsonWriter.key("EventTime").value(event.getEventTime());
            }
            if (event.getUsername() != null) {
                jsonWriter.key("Username").value((Object)event.getUsername());
            }
            if (!(resourcesList = (SdkInternalList)event.getResources()).isEmpty() || !resourcesList.isAutoConstruct()) {
                jsonWriter.key("Resources");
                jsonWriter.array();
                for (Resource resourcesListValue : resourcesList) {
                    if (resourcesListValue == null) continue;
                    ResourceJsonMarshaller.getInstance().marshall(resourcesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (event.getCloudTrailEvent() != null) {
                jsonWriter.key("CloudTrailEvent").value((Object)event.getCloudTrailEvent());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EventJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EventJsonMarshaller();
        }
        return instance;
    }
}

