/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cloudtrail.model.AddTagsRequest;
import com.amazonaws.services.cloudtrail.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class AddTagsRequestMarshaller
implements Marshaller<Request<AddTagsRequest>, AddTagsRequest> {
    public Request<AddTagsRequest> marshall(AddTagsRequest addTagsRequest) {
        if (addTagsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)addTagsRequest, "AWSCloudTrail");
        String target = "CloudTrail_20131101.AddTags";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag tagsListList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (addTagsRequest.getResourceId() != null) {
                jsonWriter.key("ResourceId").value((Object)addTagsRequest.getResourceId());
            }
            if (!((tagsListList = (ListWithAutoConstructFlag)addTagsRequest.getTagsList()) == null || tagsListList.isAutoConstruct() && tagsListList.isEmpty())) {
                jsonWriter.key("TagsList");
                jsonWriter.array();
                for (Tag tagsListListValue : tagsListList) {
                    if (tagsListListValue == null) continue;
                    jsonWriter.object();
                    if (tagsListListValue.getKey() != null) {
                        jsonWriter.key("Key").value((Object)tagsListListValue.getKey());
                    }
                    if (tagsListListValue.getValue() != null) {
                        jsonWriter.key("Value").value((Object)tagsListListValue.getValue());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

