/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchdomain.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cloudsearchdomain.model.SuggestionMatch;
import com.amazonaws.services.cloudsearchdomain.model.transform.SuggestModelMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class SuggestModel
implements Serializable,
Cloneable,
StructuredPojo {
    private String query;
    private Long found;
    private SdkInternalList<SuggestionMatch> suggestions;

    public void setQuery(String query) {
        this.query = query;
    }

    public String getQuery() {
        return this.query;
    }

    public SuggestModel withQuery(String query) {
        this.setQuery(query);
        return this;
    }

    public void setFound(Long found) {
        this.found = found;
    }

    public Long getFound() {
        return this.found;
    }

    public SuggestModel withFound(Long found) {
        this.setFound(found);
        return this;
    }

    public List<SuggestionMatch> getSuggestions() {
        if (this.suggestions == null) {
            this.suggestions = new SdkInternalList();
        }
        return this.suggestions;
    }

    public void setSuggestions(Collection<SuggestionMatch> suggestions) {
        if (suggestions == null) {
            this.suggestions = null;
            return;
        }
        this.suggestions = new SdkInternalList(suggestions);
    }

    public SuggestModel withSuggestions(SuggestionMatch ... suggestions) {
        if (this.suggestions == null) {
            this.setSuggestions((Collection<SuggestionMatch>)new SdkInternalList(suggestions.length));
        }
        for (SuggestionMatch ele : suggestions) {
            this.suggestions.add((Object)ele);
        }
        return this;
    }

    public SuggestModel withSuggestions(Collection<SuggestionMatch> suggestions) {
        this.setSuggestions(suggestions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQuery() != null) {
            sb.append("Query: ").append(this.getQuery()).append(",");
        }
        if (this.getFound() != null) {
            sb.append("Found: ").append(this.getFound()).append(",");
        }
        if (this.getSuggestions() != null) {
            sb.append("Suggestions: ").append(this.getSuggestions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuggestModel)) {
            return false;
        }
        SuggestModel other = (SuggestModel)obj;
        if (other.getQuery() == null ^ this.getQuery() == null) {
            return false;
        }
        if (other.getQuery() != null && !other.getQuery().equals(this.getQuery())) {
            return false;
        }
        if (other.getFound() == null ^ this.getFound() == null) {
            return false;
        }
        if (other.getFound() != null && !other.getFound().equals(this.getFound())) {
            return false;
        }
        if (other.getSuggestions() == null ^ this.getSuggestions() == null) {
            return false;
        }
        return other.getSuggestions() == null || other.getSuggestions().equals(this.getSuggestions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQuery() == null ? 0 : this.getQuery().hashCode());
        hashCode = 31 * hashCode + (this.getFound() == null ? 0 : this.getFound().hashCode());
        hashCode = 31 * hashCode + (this.getSuggestions() == null ? 0 : this.getSuggestions().hashCode());
        return hashCode;
    }

    public SuggestModel clone() {
        try {
            return (SuggestModel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SuggestModelMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

