/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchv2;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.cloudsearchv2.AmazonCloudSearch;
import com.amazonaws.services.cloudsearchv2.AmazonCloudSearchClientBuilder;
import com.amazonaws.services.cloudsearchv2.model.AmazonCloudSearchException;
import com.amazonaws.services.cloudsearchv2.model.BuildSuggestersRequest;
import com.amazonaws.services.cloudsearchv2.model.BuildSuggestersResult;
import com.amazonaws.services.cloudsearchv2.model.CreateDomainRequest;
import com.amazonaws.services.cloudsearchv2.model.CreateDomainResult;
import com.amazonaws.services.cloudsearchv2.model.DefineAnalysisSchemeRequest;
import com.amazonaws.services.cloudsearchv2.model.DefineAnalysisSchemeResult;
import com.amazonaws.services.cloudsearchv2.model.DefineExpressionRequest;
import com.amazonaws.services.cloudsearchv2.model.DefineExpressionResult;
import com.amazonaws.services.cloudsearchv2.model.DefineIndexFieldRequest;
import com.amazonaws.services.cloudsearchv2.model.DefineIndexFieldResult;
import com.amazonaws.services.cloudsearchv2.model.DefineSuggesterRequest;
import com.amazonaws.services.cloudsearchv2.model.DefineSuggesterResult;
import com.amazonaws.services.cloudsearchv2.model.DeleteAnalysisSchemeRequest;
import com.amazonaws.services.cloudsearchv2.model.DeleteAnalysisSchemeResult;
import com.amazonaws.services.cloudsearchv2.model.DeleteDomainRequest;
import com.amazonaws.services.cloudsearchv2.model.DeleteDomainResult;
import com.amazonaws.services.cloudsearchv2.model.DeleteExpressionRequest;
import com.amazonaws.services.cloudsearchv2.model.DeleteExpressionResult;
import com.amazonaws.services.cloudsearchv2.model.DeleteIndexFieldRequest;
import com.amazonaws.services.cloudsearchv2.model.DeleteIndexFieldResult;
import com.amazonaws.services.cloudsearchv2.model.DeleteSuggesterRequest;
import com.amazonaws.services.cloudsearchv2.model.DeleteSuggesterResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeAnalysisSchemesRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeAnalysisSchemesResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeAvailabilityOptionsRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeAvailabilityOptionsResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeDomainEndpointOptionsRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeDomainEndpointOptionsResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeDomainsRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeDomainsResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeExpressionsRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeExpressionsResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeIndexFieldsRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeIndexFieldsResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeScalingParametersRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeScalingParametersResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeServiceAccessPoliciesRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeServiceAccessPoliciesResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeSuggestersRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeSuggestersResult;
import com.amazonaws.services.cloudsearchv2.model.IndexDocumentsRequest;
import com.amazonaws.services.cloudsearchv2.model.IndexDocumentsResult;
import com.amazonaws.services.cloudsearchv2.model.ListDomainNamesRequest;
import com.amazonaws.services.cloudsearchv2.model.ListDomainNamesResult;
import com.amazonaws.services.cloudsearchv2.model.UpdateAvailabilityOptionsRequest;
import com.amazonaws.services.cloudsearchv2.model.UpdateAvailabilityOptionsResult;
import com.amazonaws.services.cloudsearchv2.model.UpdateDomainEndpointOptionsRequest;
import com.amazonaws.services.cloudsearchv2.model.UpdateDomainEndpointOptionsResult;
import com.amazonaws.services.cloudsearchv2.model.UpdateScalingParametersRequest;
import com.amazonaws.services.cloudsearchv2.model.UpdateScalingParametersResult;
import com.amazonaws.services.cloudsearchv2.model.UpdateServiceAccessPoliciesRequest;
import com.amazonaws.services.cloudsearchv2.model.UpdateServiceAccessPoliciesResult;
import com.amazonaws.services.cloudsearchv2.model.transform.BaseExceptionUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.BuildSuggestersRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.BuildSuggestersResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.CreateDomainRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.CreateDomainResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DefineAnalysisSchemeRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DefineAnalysisSchemeResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DefineExpressionRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DefineExpressionResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DefineIndexFieldRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DefineIndexFieldResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DefineSuggesterRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DefineSuggesterResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DeleteAnalysisSchemeRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DeleteAnalysisSchemeResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DeleteDomainRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DeleteDomainResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DeleteExpressionRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DeleteExpressionResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DeleteIndexFieldRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DeleteIndexFieldResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DeleteSuggesterRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DeleteSuggesterResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeAnalysisSchemesRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeAnalysisSchemesResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeAvailabilityOptionsRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeAvailabilityOptionsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeDomainEndpointOptionsRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeDomainEndpointOptionsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeDomainsRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeDomainsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeExpressionsRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeExpressionsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeIndexFieldsRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeIndexFieldsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeScalingParametersRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeScalingParametersResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeServiceAccessPoliciesRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeServiceAccessPoliciesResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeSuggestersRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeSuggestersResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DisabledOperationExceptionUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.IndexDocumentsRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.IndexDocumentsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.InternalExceptionUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.InvalidTypeExceptionUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.ListDomainNamesRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.ListDomainNamesResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.UpdateAvailabilityOptionsRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.UpdateAvailabilityOptionsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.UpdateDomainEndpointOptionsRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.UpdateDomainEndpointOptionsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.UpdateScalingParametersRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.UpdateScalingParametersResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.UpdateServiceAccessPoliciesRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.UpdateServiceAccessPoliciesResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

@ThreadSafe
public class AmazonCloudSearchClient
extends AmazonWebServiceClient
implements AmazonCloudSearch {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonCloudSearch.class);
    private static final String DEFAULT_SIGNING_NAME = "cloudsearch";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();

    @Deprecated
    public AmazonCloudSearchClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AmazonCloudSearchClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AmazonCloudSearchClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AmazonCloudSearchClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    @Deprecated
    public AmazonCloudSearchClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AmazonCloudSearchClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AmazonCloudSearchClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    public static AmazonCloudSearchClientBuilder builder() {
        return AmazonCloudSearchClientBuilder.standard();
    }

    AmazonCloudSearchClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonCloudSearchClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new DisabledOperationExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new LimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidTypeExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new ResourceNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new ValidationExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new BaseExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InternalExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new StandardErrorUnmarshaller(AmazonCloudSearchException.class));
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("https://cloudsearch.us-east-1.amazonaws.com/");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/cloudsearchv2/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/cloudsearchv2/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BuildSuggestersResult buildSuggesters(BuildSuggestersRequest request) {
        request = (BuildSuggestersRequest)this.beforeClientExecution(request);
        return this.executeBuildSuggesters(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BuildSuggestersResult executeBuildSuggesters(BuildSuggestersRequest buildSuggestersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(buildSuggestersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BuildSuggestersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BuildSuggestersRequestMarshaller().marshall((BuildSuggestersRequest)super.beforeMarshalling((AmazonWebServiceRequest)buildSuggestersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudSearch");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BuildSuggesters");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new BuildSuggestersResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            BuildSuggestersResult buildSuggestersResult = (BuildSuggestersResult)response.getAwsResponse();
            return buildSuggestersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateDomainResult createDomain(CreateDomainRequest request) {
        request = (CreateDomainRequest)this.beforeClientExecution(request);
        return this.executeCreateDomain(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDomainResult executeCreateDomain(CreateDomainRequest createDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDomainRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDomainRequestMarshaller().marshall((CreateDomainRequest)super.beforeMarshalling((AmazonWebServiceRequest)createDomainRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudSearch");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateDomain");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CreateDomainResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateDomainResult createDomainResult = (CreateDomainResult)response.getAwsResponse();
            return createDomainResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DefineAnalysisSchemeResult defineAnalysisScheme(DefineAnalysisSchemeRequest request) {
        request = (DefineAnalysisSchemeRequest)this.beforeClientExecution(request);
        return this.executeDefineAnalysisScheme(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DefineAnalysisSchemeResult executeDefineAnalysisScheme(DefineAnalysisSchemeRequest defineAnalysisSchemeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(defineAnalysisSchemeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DefineAnalysisSchemeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DefineAnalysisSchemeRequestMarshaller().marshall((DefineAnalysisSchemeRequest)super.beforeMarshalling((AmazonWebServiceRequest)defineAnalysisSchemeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudSearch");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DefineAnalysisScheme");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DefineAnalysisSchemeResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DefineAnalysisSchemeResult defineAnalysisSchemeResult = (DefineAnalysisSchemeResult)response.getAwsResponse();
            return defineAnalysisSchemeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DefineExpressionResult defineExpression(DefineExpressionRequest request) {
        request = (DefineExpressionRequest)this.beforeClientExecution(request);
        return this.executeDefineExpression(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DefineExpressionResult executeDefineExpression(DefineExpressionRequest defineExpressionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(defineExpressionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DefineExpressionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DefineExpressionRequestMarshaller().marshall((DefineExpressionRequest)super.beforeMarshalling((AmazonWebServiceRequest)defineExpressionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudSearch");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DefineExpression");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DefineExpressionResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DefineExpressionResult defineExpressionResult = (DefineExpressionResult)response.getAwsResponse();
            return defineExpressionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DefineIndexFieldResult defineIndexField(DefineIndexFieldRequest request) {
        request = (DefineIndexFieldRequest)this.beforeClientExecution(request);
        return this.executeDefineIndexField(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DefineIndexFieldResult executeDefineIndexField(DefineIndexFieldRequest defineIndexFieldRequest) {
        ExecutionContext executionContext = this.createExecutionContext(defineIndexFieldRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DefineIndexFieldRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DefineIndexFieldRequestMarshaller().marshall((DefineIndexFieldRequest)super.beforeMarshalling((AmazonWebServiceRequest)defineIndexFieldRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudSearch");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DefineIndexField");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DefineIndexFieldResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DefineIndexFieldResult defineIndexFieldResult = (DefineIndexFieldResult)response.getAwsResponse();
            return defineIndexFieldResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DefineSuggesterResult defineSuggester(DefineSuggesterRequest request) {
        request = (DefineSuggesterRequest)this.beforeClientExecution(request);
        return this.executeDefineSuggester(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DefineSuggesterResult executeDefineSuggester(DefineSuggesterRequest defineSuggesterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(defineSuggesterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DefineSuggesterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DefineSuggesterRequestMarshaller().marshall((DefineSuggesterRequest)super.beforeMarshalling((AmazonWebServiceRequest)defineSuggesterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudSearch");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DefineSuggester");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DefineSuggesterResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DefineSuggesterResult defineSuggesterResult = (DefineSuggesterResult)response.getAwsResponse();
            return defineSuggesterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteAnalysisSchemeResult deleteAnalysisScheme(DeleteAnalysisSchemeRequest request) {
        request = (DeleteAnalysisSchemeRequest)this.beforeClientExecution(request);
        return this.executeDeleteAnalysisScheme(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAnalysisSchemeResult executeDeleteAnalysisScheme(DeleteAnalysisSchemeRequest deleteAnalysisSchemeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAnalysisSchemeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAnalysisSchemeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAnalysisSchemeRequestMarshaller().marshall((DeleteAnalysisSchemeRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAnalysisSchemeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudSearch");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteAnalysisScheme");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteAnalysisSchemeResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteAnalysisSchemeResult deleteAnalysisSchemeResult = (DeleteAnalysisSchemeResult)response.getAwsResponse();
            return deleteAnalysisSchemeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDomainResult deleteDomain(DeleteDomainRequest request) {
        request = (DeleteDomainRequest)this.beforeClientExecution(request);
        return this.executeDeleteDomain(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDomainResult executeDeleteDomain(DeleteDomainRequest deleteDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDomainRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDomainRequestMarshaller().marshall((DeleteDomainRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteDomainRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudSearch");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteDomain");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteDomainResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteDomainResult deleteDomainResult = (DeleteDomainResult)response.getAwsResponse();
            return deleteDomainResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteExpressionResult deleteExpression(DeleteExpressionRequest request) {
        request = (DeleteExpressionRequest)this.beforeClientExecution(request);
        return this.executeDeleteExpression(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteExpressionResult executeDeleteExpression(DeleteExpressionRequest deleteExpressionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteExpressionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteExpressionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteExpressionRequestMarshaller().marshall((DeleteExpressionRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteExpressionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudSearch");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteExpression");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteExpressionResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteExpressionResult deleteExpressionResult = (DeleteExpressionResult)response.getAwsResponse();
            return deleteExpressionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteIndexFieldResult deleteIndexField(DeleteIndexFieldRequest request) {
        request = (DeleteIndexFieldRequest)this.beforeClientExecution(request);
        return this.executeDeleteIndexField(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteIndexFieldResult executeDeleteIndexField(DeleteIndexFieldRequest deleteIndexFieldRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteIndexFieldRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteIndexFieldRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteIndexFieldRequestMarshaller().marshall((DeleteIndexFieldRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteIndexFieldRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudSearch");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteIndexField");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteIndexFieldResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteIndexFieldResult deleteIndexFieldResult = (DeleteIndexFieldResult)response.getAwsResponse();
            return deleteIndexFieldResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteSuggesterResult deleteSuggester(DeleteSuggesterRequest request) {
        request = (DeleteSuggesterRequest)this.beforeClientExecution(request);
        return this.executeDeleteSuggester(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteSuggesterResult executeDeleteSuggester(DeleteSuggesterRequest deleteSuggesterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSuggesterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSuggesterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSuggesterRequestMarshaller().marshall((DeleteSuggesterRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteSuggesterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudSearch");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteSuggester");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteSuggesterResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteSuggesterResult deleteSuggesterResult = (DeleteSuggesterResult)response.getAwsResponse();
            return deleteSuggesterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeAnalysisSchemesResult describeAnalysisSchemes(DescribeAnalysisSchemesRequest request) {
        request = (DescribeAnalysisSchemesRequest)this.beforeClientExecution(request);
        return this.executeDescribeAnalysisSchemes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeAnalysisSchemesResult executeDescribeAnalysisSchemes(DescribeAnalysisSchemesRequest describeAnalysisSchemesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAnalysisSchemesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAnalysisSchemesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAnalysisSchemesRequestMarshaller().marshall((DescribeAnalysisSchemesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAnalysisSchemesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudSearch");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeAnalysisSchemes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeAnalysisSchemesResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeAnalysisSchemesResult describeAnalysisSchemesResult = (DescribeAnalysisSchemesResult)response.getAwsResponse();
            return describeAnalysisSchemesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeAvailabilityOptionsResult describeAvailabilityOptions(DescribeAvailabilityOptionsRequest request) {
        request = (DescribeAvailabilityOptionsRequest)this.beforeClientExecution(request);
        return this.executeDescribeAvailabilityOptions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeAvailabilityOptionsResult executeDescribeAvailabilityOptions(DescribeAvailabilityOptionsRequest describeAvailabilityOptionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAvailabilityOptionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAvailabilityOptionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAvailabilityOptionsRequestMarshaller().marshall((DescribeAvailabilityOptionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAvailabilityOptionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudSearch");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeAvailabilityOptions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeAvailabilityOptionsResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeAvailabilityOptionsResult describeAvailabilityOptionsResult = (DescribeAvailabilityOptionsResult)response.getAwsResponse();
            return describeAvailabilityOptionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDomainEndpointOptionsResult describeDomainEndpointOptions(DescribeDomainEndpointOptionsRequest request) {
        request = (DescribeDomainEndpointOptionsRequest)this.beforeClientExecution(request);
        return this.executeDescribeDomainEndpointOptions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeDomainEndpointOptionsResult executeDescribeDomainEndpointOptions(DescribeDomainEndpointOptionsRequest describeDomainEndpointOptionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDomainEndpointOptionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDomainEndpointOptionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDomainEndpointOptionsRequestMarshaller().marshall((DescribeDomainEndpointOptionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeDomainEndpointOptionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudSearch");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeDomainEndpointOptions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeDomainEndpointOptionsResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeDomainEndpointOptionsResult describeDomainEndpointOptionsResult = (DescribeDomainEndpointOptionsResult)response.getAwsResponse();
            return describeDomainEndpointOptionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDomainsResult describeDomains(DescribeDomainsRequest request) {
        request = (DescribeDomainsRequest)this.beforeClientExecution(request);
        return this.executeDescribeDomains(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeDomainsResult executeDescribeDomains(DescribeDomainsRequest describeDomainsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDomainsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDomainsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDomainsRequestMarshaller().marshall((DescribeDomainsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeDomainsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudSearch");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeDomains");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeDomainsResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeDomainsResult describeDomainsResult = (DescribeDomainsResult)response.getAwsResponse();
            return describeDomainsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDomainsResult describeDomains() {
        return this.describeDomains(new DescribeDomainsRequest());
    }

    @Override
    public DescribeExpressionsResult describeExpressions(DescribeExpressionsRequest request) {
        request = (DescribeExpressionsRequest)this.beforeClientExecution(request);
        return this.executeDescribeExpressions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeExpressionsResult executeDescribeExpressions(DescribeExpressionsRequest describeExpressionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeExpressionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeExpressionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeExpressionsRequestMarshaller().marshall((DescribeExpressionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeExpressionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudSearch");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeExpressions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeExpressionsResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeExpressionsResult describeExpressionsResult = (DescribeExpressionsResult)response.getAwsResponse();
            return describeExpressionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeIndexFieldsResult describeIndexFields(DescribeIndexFieldsRequest request) {
        request = (DescribeIndexFieldsRequest)this.beforeClientExecution(request);
        return this.executeDescribeIndexFields(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeIndexFieldsResult executeDescribeIndexFields(DescribeIndexFieldsRequest describeIndexFieldsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeIndexFieldsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeIndexFieldsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeIndexFieldsRequestMarshaller().marshall((DescribeIndexFieldsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeIndexFieldsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudSearch");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeIndexFields");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeIndexFieldsResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeIndexFieldsResult describeIndexFieldsResult = (DescribeIndexFieldsResult)response.getAwsResponse();
            return describeIndexFieldsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeScalingParametersResult describeScalingParameters(DescribeScalingParametersRequest request) {
        request = (DescribeScalingParametersRequest)this.beforeClientExecution(request);
        return this.executeDescribeScalingParameters(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeScalingParametersResult executeDescribeScalingParameters(DescribeScalingParametersRequest describeScalingParametersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeScalingParametersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeScalingParametersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeScalingParametersRequestMarshaller().marshall((DescribeScalingParametersRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeScalingParametersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudSearch");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeScalingParameters");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeScalingParametersResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeScalingParametersResult describeScalingParametersResult = (DescribeScalingParametersResult)response.getAwsResponse();
            return describeScalingParametersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeServiceAccessPoliciesResult describeServiceAccessPolicies(DescribeServiceAccessPoliciesRequest request) {
        request = (DescribeServiceAccessPoliciesRequest)this.beforeClientExecution(request);
        return this.executeDescribeServiceAccessPolicies(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeServiceAccessPoliciesResult executeDescribeServiceAccessPolicies(DescribeServiceAccessPoliciesRequest describeServiceAccessPoliciesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeServiceAccessPoliciesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeServiceAccessPoliciesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeServiceAccessPoliciesRequestMarshaller().marshall((DescribeServiceAccessPoliciesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeServiceAccessPoliciesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudSearch");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeServiceAccessPolicies");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeServiceAccessPoliciesResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeServiceAccessPoliciesResult describeServiceAccessPoliciesResult = (DescribeServiceAccessPoliciesResult)response.getAwsResponse();
            return describeServiceAccessPoliciesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeSuggestersResult describeSuggesters(DescribeSuggestersRequest request) {
        request = (DescribeSuggestersRequest)this.beforeClientExecution(request);
        return this.executeDescribeSuggesters(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeSuggestersResult executeDescribeSuggesters(DescribeSuggestersRequest describeSuggestersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeSuggestersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeSuggestersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeSuggestersRequestMarshaller().marshall((DescribeSuggestersRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeSuggestersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudSearch");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeSuggesters");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeSuggestersResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeSuggestersResult describeSuggestersResult = (DescribeSuggestersResult)response.getAwsResponse();
            return describeSuggestersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public IndexDocumentsResult indexDocuments(IndexDocumentsRequest request) {
        request = (IndexDocumentsRequest)this.beforeClientExecution(request);
        return this.executeIndexDocuments(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final IndexDocumentsResult executeIndexDocuments(IndexDocumentsRequest indexDocumentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(indexDocumentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<IndexDocumentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new IndexDocumentsRequestMarshaller().marshall((IndexDocumentsRequest)super.beforeMarshalling((AmazonWebServiceRequest)indexDocumentsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudSearch");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"IndexDocuments");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new IndexDocumentsResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            IndexDocumentsResult indexDocumentsResult = (IndexDocumentsResult)response.getAwsResponse();
            return indexDocumentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDomainNamesResult listDomainNames(ListDomainNamesRequest request) {
        request = (ListDomainNamesRequest)this.beforeClientExecution(request);
        return this.executeListDomainNames(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDomainNamesResult executeListDomainNames(ListDomainNamesRequest listDomainNamesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDomainNamesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDomainNamesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDomainNamesRequestMarshaller().marshall((ListDomainNamesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDomainNamesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudSearch");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDomainNames");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListDomainNamesResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListDomainNamesResult listDomainNamesResult = (ListDomainNamesResult)response.getAwsResponse();
            return listDomainNamesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDomainNamesResult listDomainNames() {
        return this.listDomainNames(new ListDomainNamesRequest());
    }

    @Override
    public UpdateAvailabilityOptionsResult updateAvailabilityOptions(UpdateAvailabilityOptionsRequest request) {
        request = (UpdateAvailabilityOptionsRequest)this.beforeClientExecution(request);
        return this.executeUpdateAvailabilityOptions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateAvailabilityOptionsResult executeUpdateAvailabilityOptions(UpdateAvailabilityOptionsRequest updateAvailabilityOptionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateAvailabilityOptionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateAvailabilityOptionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateAvailabilityOptionsRequestMarshaller().marshall((UpdateAvailabilityOptionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateAvailabilityOptionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudSearch");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateAvailabilityOptions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new UpdateAvailabilityOptionsResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            UpdateAvailabilityOptionsResult updateAvailabilityOptionsResult = (UpdateAvailabilityOptionsResult)response.getAwsResponse();
            return updateAvailabilityOptionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateDomainEndpointOptionsResult updateDomainEndpointOptions(UpdateDomainEndpointOptionsRequest request) {
        request = (UpdateDomainEndpointOptionsRequest)this.beforeClientExecution(request);
        return this.executeUpdateDomainEndpointOptions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateDomainEndpointOptionsResult executeUpdateDomainEndpointOptions(UpdateDomainEndpointOptionsRequest updateDomainEndpointOptionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDomainEndpointOptionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDomainEndpointOptionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDomainEndpointOptionsRequestMarshaller().marshall((UpdateDomainEndpointOptionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateDomainEndpointOptionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudSearch");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateDomainEndpointOptions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new UpdateDomainEndpointOptionsResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            UpdateDomainEndpointOptionsResult updateDomainEndpointOptionsResult = (UpdateDomainEndpointOptionsResult)response.getAwsResponse();
            return updateDomainEndpointOptionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateScalingParametersResult updateScalingParameters(UpdateScalingParametersRequest request) {
        request = (UpdateScalingParametersRequest)this.beforeClientExecution(request);
        return this.executeUpdateScalingParameters(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateScalingParametersResult executeUpdateScalingParameters(UpdateScalingParametersRequest updateScalingParametersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateScalingParametersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateScalingParametersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateScalingParametersRequestMarshaller().marshall((UpdateScalingParametersRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateScalingParametersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudSearch");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateScalingParameters");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new UpdateScalingParametersResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            UpdateScalingParametersResult updateScalingParametersResult = (UpdateScalingParametersResult)response.getAwsResponse();
            return updateScalingParametersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateServiceAccessPoliciesResult updateServiceAccessPolicies(UpdateServiceAccessPoliciesRequest request) {
        request = (UpdateServiceAccessPoliciesRequest)this.beforeClientExecution(request);
        return this.executeUpdateServiceAccessPolicies(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateServiceAccessPoliciesResult executeUpdateServiceAccessPolicies(UpdateServiceAccessPoliciesRequest updateServiceAccessPoliciesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateServiceAccessPoliciesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateServiceAccessPoliciesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateServiceAccessPoliciesRequestMarshaller().marshall((UpdateServiceAccessPoliciesRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateServiceAccessPoliciesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudSearch");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateServiceAccessPolicies");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new UpdateServiceAccessPoliciesResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            UpdateServiceAccessPoliciesResult updateServiceAccessPoliciesResult = (UpdateServiceAccessPoliciesResult)response.getAwsResponse();
            return updateServiceAccessPoliciesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.client.execute(request, responseHandler, (HttpResponseHandler)errorResponseHandler, executionContext);
    }
}

