/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchdomain.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.cloudsearchdomain.model.SearchRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.UriResourcePathUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class SearchRequestMarshaller
implements Marshaller<Request<SearchRequest>, SearchRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public SearchRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<SearchRequest> marshall(SearchRequest searchRequest) {
        if (searchRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)searchRequest, "AmazonCloudSearchDomain");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-01-01/search?format=sdk&pretty=true";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest((Request)request, (String)uriResourcePath);
        request.setResourcePath(uriResourcePath);
        if (searchRequest.getCursor() != null) {
            request.addParameter("cursor", StringUtils.fromString((String)searchRequest.getCursor()));
        }
        if (searchRequest.getExpr() != null) {
            request.addParameter("expr", StringUtils.fromString((String)searchRequest.getExpr()));
        }
        if (searchRequest.getFacet() != null) {
            request.addParameter("facet", StringUtils.fromString((String)searchRequest.getFacet()));
        }
        if (searchRequest.getFilterQuery() != null) {
            request.addParameter("fq", StringUtils.fromString((String)searchRequest.getFilterQuery()));
        }
        if (searchRequest.getHighlight() != null) {
            request.addParameter("highlight", StringUtils.fromString((String)searchRequest.getHighlight()));
        }
        if (searchRequest.getPartial() != null) {
            request.addParameter("partial", StringUtils.fromBoolean((Boolean)searchRequest.getPartial()));
        }
        if (searchRequest.getQuery() != null) {
            request.addParameter("q", StringUtils.fromString((String)searchRequest.getQuery()));
        }
        if (searchRequest.getQueryOptions() != null) {
            request.addParameter("q.options", StringUtils.fromString((String)searchRequest.getQueryOptions()));
        }
        if (searchRequest.getQueryParser() != null) {
            request.addParameter("q.parser", StringUtils.fromString((String)searchRequest.getQueryParser()));
        }
        if (searchRequest.getReturn() != null) {
            request.addParameter("return", StringUtils.fromString((String)searchRequest.getReturn()));
        }
        if (searchRequest.getSize() != null) {
            request.addParameter("size", StringUtils.fromLong((Long)searchRequest.getSize()));
        }
        if (searchRequest.getSort() != null) {
            request.addParameter("sort", StringUtils.fromString((String)searchRequest.getSort()));
        }
        if (searchRequest.getStart() != null) {
            request.addParameter("start", StringUtils.fromLong((Long)searchRequest.getStart()));
        }
        if (searchRequest.getStats() != null) {
            request.addParameter("stats", StringUtils.fromString((String)searchRequest.getStats()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

