/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudhsm;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cloudhsm.AWSCloudHSMAsync;
import com.amazonaws.services.cloudhsm.AWSCloudHSMClient;
import com.amazonaws.services.cloudhsm.model.CreateHapgRequest;
import com.amazonaws.services.cloudhsm.model.CreateHapgResult;
import com.amazonaws.services.cloudhsm.model.CreateHsmRequest;
import com.amazonaws.services.cloudhsm.model.CreateHsmResult;
import com.amazonaws.services.cloudhsm.model.CreateLunaClientRequest;
import com.amazonaws.services.cloudhsm.model.CreateLunaClientResult;
import com.amazonaws.services.cloudhsm.model.DeleteHapgRequest;
import com.amazonaws.services.cloudhsm.model.DeleteHapgResult;
import com.amazonaws.services.cloudhsm.model.DeleteHsmRequest;
import com.amazonaws.services.cloudhsm.model.DeleteHsmResult;
import com.amazonaws.services.cloudhsm.model.DeleteLunaClientRequest;
import com.amazonaws.services.cloudhsm.model.DeleteLunaClientResult;
import com.amazonaws.services.cloudhsm.model.DescribeHapgRequest;
import com.amazonaws.services.cloudhsm.model.DescribeHapgResult;
import com.amazonaws.services.cloudhsm.model.DescribeHsmRequest;
import com.amazonaws.services.cloudhsm.model.DescribeHsmResult;
import com.amazonaws.services.cloudhsm.model.DescribeLunaClientRequest;
import com.amazonaws.services.cloudhsm.model.DescribeLunaClientResult;
import com.amazonaws.services.cloudhsm.model.GetConfigRequest;
import com.amazonaws.services.cloudhsm.model.GetConfigResult;
import com.amazonaws.services.cloudhsm.model.ListAvailableZonesRequest;
import com.amazonaws.services.cloudhsm.model.ListAvailableZonesResult;
import com.amazonaws.services.cloudhsm.model.ListHapgsRequest;
import com.amazonaws.services.cloudhsm.model.ListHapgsResult;
import com.amazonaws.services.cloudhsm.model.ListHsmsRequest;
import com.amazonaws.services.cloudhsm.model.ListHsmsResult;
import com.amazonaws.services.cloudhsm.model.ListLunaClientsRequest;
import com.amazonaws.services.cloudhsm.model.ListLunaClientsResult;
import com.amazonaws.services.cloudhsm.model.ModifyHapgRequest;
import com.amazonaws.services.cloudhsm.model.ModifyHapgResult;
import com.amazonaws.services.cloudhsm.model.ModifyHsmRequest;
import com.amazonaws.services.cloudhsm.model.ModifyHsmResult;
import com.amazonaws.services.cloudhsm.model.ModifyLunaClientRequest;
import com.amazonaws.services.cloudhsm.model.ModifyLunaClientResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AWSCloudHSMAsyncClient
extends AWSCloudHSMClient
implements AWSCloudHSMAsync {
    private final ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AWSCloudHSMAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AWSCloudHSMAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSCloudHSMAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSCloudHSMAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AWSCloudHSMAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSCloudHSMAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSCloudHSMAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AWSCloudHSMAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSCloudHSMAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<GetConfigResult> getConfigAsync(final GetConfigRequest getConfigRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetConfigResult>(){

            @Override
            public GetConfigResult call() throws Exception {
                return AWSCloudHSMAsyncClient.this.getConfig(getConfigRequest);
            }
        });
    }

    @Override
    public Future<GetConfigResult> getConfigAsync(final GetConfigRequest getConfigRequest, final AsyncHandler<GetConfigRequest, GetConfigResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetConfigResult>(){

            @Override
            public GetConfigResult call() throws Exception {
                GetConfigResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.getConfig(getConfigRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getConfigRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateHapgResult> createHapgAsync(final CreateHapgRequest createHapgRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateHapgResult>(){

            @Override
            public CreateHapgResult call() throws Exception {
                return AWSCloudHSMAsyncClient.this.createHapg(createHapgRequest);
            }
        });
    }

    @Override
    public Future<CreateHapgResult> createHapgAsync(final CreateHapgRequest createHapgRequest, final AsyncHandler<CreateHapgRequest, CreateHapgResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateHapgResult>(){

            @Override
            public CreateHapgResult call() throws Exception {
                CreateHapgResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.createHapg(createHapgRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createHapgRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeHapgResult> describeHapgAsync(final DescribeHapgRequest describeHapgRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeHapgResult>(){

            @Override
            public DescribeHapgResult call() throws Exception {
                return AWSCloudHSMAsyncClient.this.describeHapg(describeHapgRequest);
            }
        });
    }

    @Override
    public Future<DescribeHapgResult> describeHapgAsync(final DescribeHapgRequest describeHapgRequest, final AsyncHandler<DescribeHapgRequest, DescribeHapgResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeHapgResult>(){

            @Override
            public DescribeHapgResult call() throws Exception {
                DescribeHapgResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.describeHapg(describeHapgRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeHapgRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListAvailableZonesResult> listAvailableZonesAsync(final ListAvailableZonesRequest listAvailableZonesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListAvailableZonesResult>(){

            @Override
            public ListAvailableZonesResult call() throws Exception {
                return AWSCloudHSMAsyncClient.this.listAvailableZones(listAvailableZonesRequest);
            }
        });
    }

    @Override
    public Future<ListAvailableZonesResult> listAvailableZonesAsync(final ListAvailableZonesRequest listAvailableZonesRequest, final AsyncHandler<ListAvailableZonesRequest, ListAvailableZonesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListAvailableZonesResult>(){

            @Override
            public ListAvailableZonesResult call() throws Exception {
                ListAvailableZonesResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.listAvailableZones(listAvailableZonesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listAvailableZonesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ModifyHsmResult> modifyHsmAsync(final ModifyHsmRequest modifyHsmRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ModifyHsmResult>(){

            @Override
            public ModifyHsmResult call() throws Exception {
                return AWSCloudHSMAsyncClient.this.modifyHsm(modifyHsmRequest);
            }
        });
    }

    @Override
    public Future<ModifyHsmResult> modifyHsmAsync(final ModifyHsmRequest modifyHsmRequest, final AsyncHandler<ModifyHsmRequest, ModifyHsmResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ModifyHsmResult>(){

            @Override
            public ModifyHsmResult call() throws Exception {
                ModifyHsmResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.modifyHsm(modifyHsmRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)modifyHsmRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListLunaClientsResult> listLunaClientsAsync(final ListLunaClientsRequest listLunaClientsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListLunaClientsResult>(){

            @Override
            public ListLunaClientsResult call() throws Exception {
                return AWSCloudHSMAsyncClient.this.listLunaClients(listLunaClientsRequest);
            }
        });
    }

    @Override
    public Future<ListLunaClientsResult> listLunaClientsAsync(final ListLunaClientsRequest listLunaClientsRequest, final AsyncHandler<ListLunaClientsRequest, ListLunaClientsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListLunaClientsResult>(){

            @Override
            public ListLunaClientsResult call() throws Exception {
                ListLunaClientsResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.listLunaClients(listLunaClientsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listLunaClientsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListHapgsResult> listHapgsAsync(final ListHapgsRequest listHapgsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListHapgsResult>(){

            @Override
            public ListHapgsResult call() throws Exception {
                return AWSCloudHSMAsyncClient.this.listHapgs(listHapgsRequest);
            }
        });
    }

    @Override
    public Future<ListHapgsResult> listHapgsAsync(final ListHapgsRequest listHapgsRequest, final AsyncHandler<ListHapgsRequest, ListHapgsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListHapgsResult>(){

            @Override
            public ListHapgsResult call() throws Exception {
                ListHapgsResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.listHapgs(listHapgsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listHapgsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteHsmResult> deleteHsmAsync(final DeleteHsmRequest deleteHsmRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteHsmResult>(){

            @Override
            public DeleteHsmResult call() throws Exception {
                return AWSCloudHSMAsyncClient.this.deleteHsm(deleteHsmRequest);
            }
        });
    }

    @Override
    public Future<DeleteHsmResult> deleteHsmAsync(final DeleteHsmRequest deleteHsmRequest, final AsyncHandler<DeleteHsmRequest, DeleteHsmResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteHsmResult>(){

            @Override
            public DeleteHsmResult call() throws Exception {
                DeleteHsmResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.deleteHsm(deleteHsmRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteHsmRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateHsmResult> createHsmAsync(final CreateHsmRequest createHsmRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateHsmResult>(){

            @Override
            public CreateHsmResult call() throws Exception {
                return AWSCloudHSMAsyncClient.this.createHsm(createHsmRequest);
            }
        });
    }

    @Override
    public Future<CreateHsmResult> createHsmAsync(final CreateHsmRequest createHsmRequest, final AsyncHandler<CreateHsmRequest, CreateHsmResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateHsmResult>(){

            @Override
            public CreateHsmResult call() throws Exception {
                CreateHsmResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.createHsm(createHsmRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createHsmRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListHsmsResult> listHsmsAsync(final ListHsmsRequest listHsmsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListHsmsResult>(){

            @Override
            public ListHsmsResult call() throws Exception {
                return AWSCloudHSMAsyncClient.this.listHsms(listHsmsRequest);
            }
        });
    }

    @Override
    public Future<ListHsmsResult> listHsmsAsync(final ListHsmsRequest listHsmsRequest, final AsyncHandler<ListHsmsRequest, ListHsmsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListHsmsResult>(){

            @Override
            public ListHsmsResult call() throws Exception {
                ListHsmsResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.listHsms(listHsmsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listHsmsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeHsmResult> describeHsmAsync(final DescribeHsmRequest describeHsmRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeHsmResult>(){

            @Override
            public DescribeHsmResult call() throws Exception {
                return AWSCloudHSMAsyncClient.this.describeHsm(describeHsmRequest);
            }
        });
    }

    @Override
    public Future<DescribeHsmResult> describeHsmAsync(final DescribeHsmRequest describeHsmRequest, final AsyncHandler<DescribeHsmRequest, DescribeHsmResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeHsmResult>(){

            @Override
            public DescribeHsmResult call() throws Exception {
                DescribeHsmResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.describeHsm(describeHsmRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeHsmRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteHapgResult> deleteHapgAsync(final DeleteHapgRequest deleteHapgRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteHapgResult>(){

            @Override
            public DeleteHapgResult call() throws Exception {
                return AWSCloudHSMAsyncClient.this.deleteHapg(deleteHapgRequest);
            }
        });
    }

    @Override
    public Future<DeleteHapgResult> deleteHapgAsync(final DeleteHapgRequest deleteHapgRequest, final AsyncHandler<DeleteHapgRequest, DeleteHapgResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteHapgResult>(){

            @Override
            public DeleteHapgResult call() throws Exception {
                DeleteHapgResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.deleteHapg(deleteHapgRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteHapgRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ModifyHapgResult> modifyHapgAsync(final ModifyHapgRequest modifyHapgRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ModifyHapgResult>(){

            @Override
            public ModifyHapgResult call() throws Exception {
                return AWSCloudHSMAsyncClient.this.modifyHapg(modifyHapgRequest);
            }
        });
    }

    @Override
    public Future<ModifyHapgResult> modifyHapgAsync(final ModifyHapgRequest modifyHapgRequest, final AsyncHandler<ModifyHapgRequest, ModifyHapgResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ModifyHapgResult>(){

            @Override
            public ModifyHapgResult call() throws Exception {
                ModifyHapgResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.modifyHapg(modifyHapgRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)modifyHapgRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateLunaClientResult> createLunaClientAsync(final CreateLunaClientRequest createLunaClientRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateLunaClientResult>(){

            @Override
            public CreateLunaClientResult call() throws Exception {
                return AWSCloudHSMAsyncClient.this.createLunaClient(createLunaClientRequest);
            }
        });
    }

    @Override
    public Future<CreateLunaClientResult> createLunaClientAsync(final CreateLunaClientRequest createLunaClientRequest, final AsyncHandler<CreateLunaClientRequest, CreateLunaClientResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateLunaClientResult>(){

            @Override
            public CreateLunaClientResult call() throws Exception {
                CreateLunaClientResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.createLunaClient(createLunaClientRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createLunaClientRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteLunaClientResult> deleteLunaClientAsync(final DeleteLunaClientRequest deleteLunaClientRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteLunaClientResult>(){

            @Override
            public DeleteLunaClientResult call() throws Exception {
                return AWSCloudHSMAsyncClient.this.deleteLunaClient(deleteLunaClientRequest);
            }
        });
    }

    @Override
    public Future<DeleteLunaClientResult> deleteLunaClientAsync(final DeleteLunaClientRequest deleteLunaClientRequest, final AsyncHandler<DeleteLunaClientRequest, DeleteLunaClientResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteLunaClientResult>(){

            @Override
            public DeleteLunaClientResult call() throws Exception {
                DeleteLunaClientResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.deleteLunaClient(deleteLunaClientRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteLunaClientRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ModifyLunaClientResult> modifyLunaClientAsync(final ModifyLunaClientRequest modifyLunaClientRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ModifyLunaClientResult>(){

            @Override
            public ModifyLunaClientResult call() throws Exception {
                return AWSCloudHSMAsyncClient.this.modifyLunaClient(modifyLunaClientRequest);
            }
        });
    }

    @Override
    public Future<ModifyLunaClientResult> modifyLunaClientAsync(final ModifyLunaClientRequest modifyLunaClientRequest, final AsyncHandler<ModifyLunaClientRequest, ModifyLunaClientResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ModifyLunaClientResult>(){

            @Override
            public ModifyLunaClientResult call() throws Exception {
                ModifyLunaClientResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.modifyLunaClient(modifyLunaClientRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)modifyLunaClientRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeLunaClientResult> describeLunaClientAsync(final DescribeLunaClientRequest describeLunaClientRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeLunaClientResult>(){

            @Override
            public DescribeLunaClientResult call() throws Exception {
                return AWSCloudHSMAsyncClient.this.describeLunaClient(describeLunaClientRequest);
            }
        });
    }

    @Override
    public Future<DescribeLunaClientResult> describeLunaClientAsync(final DescribeLunaClientRequest describeLunaClientRequest, final AsyncHandler<DescribeLunaClientRequest, DescribeLunaClientResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeLunaClientResult>(){

            @Override
            public DescribeLunaClientResult call() throws Exception {
                DescribeLunaClientResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.describeLunaClient(describeLunaClientRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeLunaClientRequest, (Object)result);
                return result;
            }
        });
    }
}

