/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.OriginAccessControl;
import com.amazonaws.services.cloudfront.model.transform.OriginAccessControlConfigStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class OriginAccessControlStaxUnmarshaller
implements Unmarshaller<OriginAccessControl, StaxUnmarshallerContext> {
    private static OriginAccessControlStaxUnmarshaller instance;

    public OriginAccessControl unmarshall(StaxUnmarshallerContext context) throws Exception {
        OriginAccessControl originAccessControl = new OriginAccessControl();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return originAccessControl;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Id", targetDepth)) {
                    originAccessControl.setId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("OriginAccessControlConfig", targetDepth)) continue;
                originAccessControl.setOriginAccessControlConfig(OriginAccessControlConfigStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return originAccessControl;
    }

    public static OriginAccessControlStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new OriginAccessControlStaxUnmarshaller();
        }
        return instance;
    }
}

