/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.TestResult;
import com.amazonaws.services.cloudfront.model.transform.FunctionSummaryStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class TestResultStaxUnmarshaller
implements Unmarshaller<TestResult, StaxUnmarshallerContext> {
    private static TestResultStaxUnmarshaller instance;

    public TestResult unmarshall(StaxUnmarshallerContext context) throws Exception {
        TestResult testResult = new TestResult();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return testResult;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("FunctionSummary", targetDepth)) {
                    testResult.setFunctionSummary(FunctionSummaryStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ComputeUtilization", targetDepth)) {
                    testResult.setComputeUtilization(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("FunctionExecutionLogs", targetDepth)) {
                    testResult.withFunctionExecutionLogs(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("FunctionExecutionLogs/member", targetDepth)) {
                    testResult.withFunctionExecutionLogs(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("FunctionErrorMessage", targetDepth)) {
                    testResult.setFunctionErrorMessage(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("FunctionOutput", targetDepth)) continue;
                testResult.setFunctionOutput(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return testResult;
    }

    public static TestResultStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new TestResultStaxUnmarshaller();
        }
        return instance;
    }
}

