/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.DeleteKeyGroupRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;

public class DeleteKeyGroupRequestMarshaller
implements Marshaller<Request<DeleteKeyGroupRequest>, DeleteKeyGroupRequest> {
    public Request<DeleteKeyGroupRequest> marshall(DeleteKeyGroupRequest deleteKeyGroupRequest) {
        if (deleteKeyGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteKeyGroupRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (deleteKeyGroupRequest.getIfMatch() != null) {
            request.addHeader("If-Match", StringUtils.fromString((String)deleteKeyGroupRequest.getIfMatch()));
        }
        String uriResourcePath = "/2020-05-31/key-group/{Id}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Id", deleteKeyGroupRequest.getId());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

