/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.CopyDistributionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CopyDistributionRequestMarshaller
implements Marshaller<Request<CopyDistributionRequest>, CopyDistributionRequest> {
    public Request<CopyDistributionRequest> marshall(CopyDistributionRequest copyDistributionRequest) {
        if (copyDistributionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)copyDistributionRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.POST);
        if (copyDistributionRequest.getStaging() != null) {
            request.addHeader("Staging", StringUtils.fromBoolean((Boolean)copyDistributionRequest.getStaging()));
        }
        if (copyDistributionRequest.getIfMatch() != null) {
            request.addHeader("If-Match", StringUtils.fromString((String)copyDistributionRequest.getIfMatch()));
        }
        String uriResourcePath = "/2020-05-31/distribution/{PrimaryDistributionId}/copy";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "PrimaryDistributionId", copyDistributionRequest.getPrimaryDistributionId());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://cloudfront.amazonaws.com/doc/2020-05-31/");
            xmlWriter.startElement("CopyDistributionRequest");
            if (copyDistributionRequest != null && copyDistributionRequest.getCallerReference() != null) {
                xmlWriter.startElement("CallerReference").value(copyDistributionRequest.getCallerReference()).endElement();
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

