/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.TestFunctionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class TestFunctionRequestMarshaller
implements Marshaller<Request<TestFunctionRequest>, TestFunctionRequest> {
    public Request<TestFunctionRequest> marshall(TestFunctionRequest testFunctionRequest) {
        if (testFunctionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)testFunctionRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.POST);
        if (testFunctionRequest.getIfMatch() != null) {
            request.addHeader("If-Match", StringUtils.fromString((String)testFunctionRequest.getIfMatch()));
        }
        String uriResourcePath = "/2020-05-31/function/{Name}/test";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Name", testFunctionRequest.getName());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://cloudfront.amazonaws.com/doc/2020-05-31/");
            xmlWriter.startElement("TestFunctionRequest");
            if (testFunctionRequest != null) {
                if (testFunctionRequest.getStage() != null) {
                    xmlWriter.startElement("Stage").value(testFunctionRequest.getStage()).endElement();
                }
                if (testFunctionRequest.getEventObject() != null) {
                    xmlWriter.startElement("EventObject").value(testFunctionRequest.getEventObject()).endElement();
                }
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

