/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudfront.model.CreateResponseHeadersPolicyRequest;
import com.amazonaws.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowHeaders;
import com.amazonaws.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowMethods;
import com.amazonaws.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowOrigins;
import com.amazonaws.services.cloudfront.model.ResponseHeadersPolicyAccessControlExposeHeaders;
import com.amazonaws.services.cloudfront.model.ResponseHeadersPolicyConfig;
import com.amazonaws.services.cloudfront.model.ResponseHeadersPolicyContentSecurityPolicy;
import com.amazonaws.services.cloudfront.model.ResponseHeadersPolicyContentTypeOptions;
import com.amazonaws.services.cloudfront.model.ResponseHeadersPolicyCorsConfig;
import com.amazonaws.services.cloudfront.model.ResponseHeadersPolicyCustomHeader;
import com.amazonaws.services.cloudfront.model.ResponseHeadersPolicyCustomHeadersConfig;
import com.amazonaws.services.cloudfront.model.ResponseHeadersPolicyFrameOptions;
import com.amazonaws.services.cloudfront.model.ResponseHeadersPolicyReferrerPolicy;
import com.amazonaws.services.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig;
import com.amazonaws.services.cloudfront.model.ResponseHeadersPolicyStrictTransportSecurity;
import com.amazonaws.services.cloudfront.model.ResponseHeadersPolicyXSSProtection;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreateResponseHeadersPolicyRequestMarshaller
implements Marshaller<Request<CreateResponseHeadersPolicyRequest>, CreateResponseHeadersPolicyRequest> {
    public Request<CreateResponseHeadersPolicyRequest> marshall(CreateResponseHeadersPolicyRequest createResponseHeadersPolicyRequest) {
        if (createResponseHeadersPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createResponseHeadersPolicyRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2020-05-31/response-headers-policy";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://cloudfront.amazonaws.com/doc/2020-05-31/");
            ResponseHeadersPolicyConfig responseHeadersPolicyConfig = createResponseHeadersPolicyRequest.getResponseHeadersPolicyConfig();
            if (responseHeadersPolicyConfig != null) {
                ResponseHeadersPolicyCustomHeadersConfig customHeadersConfig;
                ResponseHeadersPolicySecurityHeadersConfig securityHeadersConfig;
                ResponseHeadersPolicyCorsConfig corsConfig;
                xmlWriter.startElement("ResponseHeadersPolicyConfig");
                if (responseHeadersPolicyConfig.getComment() != null) {
                    xmlWriter.startElement("Comment").value(responseHeadersPolicyConfig.getComment()).endElement();
                }
                if (responseHeadersPolicyConfig.getName() != null) {
                    xmlWriter.startElement("Name").value(responseHeadersPolicyConfig.getName()).endElement();
                }
                if ((corsConfig = responseHeadersPolicyConfig.getCorsConfig()) != null) {
                    ResponseHeadersPolicyAccessControlExposeHeaders accessControlExposeHeaders;
                    ResponseHeadersPolicyAccessControlAllowMethods accessControlAllowMethods;
                    ResponseHeadersPolicyAccessControlAllowHeaders accessControlAllowHeaders;
                    xmlWriter.startElement("CorsConfig");
                    ResponseHeadersPolicyAccessControlAllowOrigins accessControlAllowOrigins = corsConfig.getAccessControlAllowOrigins();
                    if (accessControlAllowOrigins != null) {
                        SdkInternalList responseHeadersPolicyAccessControlAllowOriginsItemsList;
                        xmlWriter.startElement("AccessControlAllowOrigins");
                        if (accessControlAllowOrigins.getQuantity() != null) {
                            xmlWriter.startElement("Quantity").value((Object)accessControlAllowOrigins.getQuantity()).endElement();
                        }
                        if (!(responseHeadersPolicyAccessControlAllowOriginsItemsList = (SdkInternalList)accessControlAllowOrigins.getItems()).isEmpty() || !responseHeadersPolicyAccessControlAllowOriginsItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");
                            for (String responseHeadersPolicyAccessControlAllowOriginsItemsListValue : responseHeadersPolicyAccessControlAllowOriginsItemsList) {
                                xmlWriter.startElement("Origin");
                                xmlWriter.value(responseHeadersPolicyAccessControlAllowOriginsItemsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((accessControlAllowHeaders = corsConfig.getAccessControlAllowHeaders()) != null) {
                        SdkInternalList responseHeadersPolicyAccessControlAllowHeadersItemsList;
                        xmlWriter.startElement("AccessControlAllowHeaders");
                        if (accessControlAllowHeaders.getQuantity() != null) {
                            xmlWriter.startElement("Quantity").value((Object)accessControlAllowHeaders.getQuantity()).endElement();
                        }
                        if (!(responseHeadersPolicyAccessControlAllowHeadersItemsList = (SdkInternalList)accessControlAllowHeaders.getItems()).isEmpty() || !responseHeadersPolicyAccessControlAllowHeadersItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");
                            for (String responseHeadersPolicyAccessControlAllowHeadersItemsListValue : responseHeadersPolicyAccessControlAllowHeadersItemsList) {
                                xmlWriter.startElement("Header");
                                xmlWriter.value(responseHeadersPolicyAccessControlAllowHeadersItemsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((accessControlAllowMethods = corsConfig.getAccessControlAllowMethods()) != null) {
                        SdkInternalList responseHeadersPolicyAccessControlAllowMethodsItemsList;
                        xmlWriter.startElement("AccessControlAllowMethods");
                        if (accessControlAllowMethods.getQuantity() != null) {
                            xmlWriter.startElement("Quantity").value((Object)accessControlAllowMethods.getQuantity()).endElement();
                        }
                        if (!(responseHeadersPolicyAccessControlAllowMethodsItemsList = (SdkInternalList)accessControlAllowMethods.getItems()).isEmpty() || !responseHeadersPolicyAccessControlAllowMethodsItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");
                            for (String responseHeadersPolicyAccessControlAllowMethodsItemsListValue : responseHeadersPolicyAccessControlAllowMethodsItemsList) {
                                xmlWriter.startElement("Method");
                                xmlWriter.value(responseHeadersPolicyAccessControlAllowMethodsItemsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if (corsConfig.getAccessControlAllowCredentials() != null) {
                        xmlWriter.startElement("AccessControlAllowCredentials").value((Object)corsConfig.getAccessControlAllowCredentials()).endElement();
                    }
                    if ((accessControlExposeHeaders = corsConfig.getAccessControlExposeHeaders()) != null) {
                        SdkInternalList responseHeadersPolicyAccessControlExposeHeadersItemsList;
                        xmlWriter.startElement("AccessControlExposeHeaders");
                        if (accessControlExposeHeaders.getQuantity() != null) {
                            xmlWriter.startElement("Quantity").value((Object)accessControlExposeHeaders.getQuantity()).endElement();
                        }
                        if (!(responseHeadersPolicyAccessControlExposeHeadersItemsList = (SdkInternalList)accessControlExposeHeaders.getItems()).isEmpty() || !responseHeadersPolicyAccessControlExposeHeadersItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");
                            for (String responseHeadersPolicyAccessControlExposeHeadersItemsListValue : responseHeadersPolicyAccessControlExposeHeadersItemsList) {
                                xmlWriter.startElement("Header");
                                xmlWriter.value(responseHeadersPolicyAccessControlExposeHeadersItemsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if (corsConfig.getAccessControlMaxAgeSec() != null) {
                        xmlWriter.startElement("AccessControlMaxAgeSec").value((Object)corsConfig.getAccessControlMaxAgeSec()).endElement();
                    }
                    if (corsConfig.getOriginOverride() != null) {
                        xmlWriter.startElement("OriginOverride").value((Object)corsConfig.getOriginOverride()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((securityHeadersConfig = responseHeadersPolicyConfig.getSecurityHeadersConfig()) != null) {
                    ResponseHeadersPolicyStrictTransportSecurity strictTransportSecurity;
                    ResponseHeadersPolicyContentTypeOptions contentTypeOptions;
                    ResponseHeadersPolicyContentSecurityPolicy contentSecurityPolicy;
                    ResponseHeadersPolicyReferrerPolicy referrerPolicy;
                    ResponseHeadersPolicyFrameOptions frameOptions;
                    xmlWriter.startElement("SecurityHeadersConfig");
                    ResponseHeadersPolicyXSSProtection xSSProtection = securityHeadersConfig.getXSSProtection();
                    if (xSSProtection != null) {
                        xmlWriter.startElement("XSSProtection");
                        if (xSSProtection.getOverride() != null) {
                            xmlWriter.startElement("Override").value((Object)xSSProtection.getOverride()).endElement();
                        }
                        if (xSSProtection.getProtection() != null) {
                            xmlWriter.startElement("Protection").value((Object)xSSProtection.getProtection()).endElement();
                        }
                        if (xSSProtection.getModeBlock() != null) {
                            xmlWriter.startElement("ModeBlock").value((Object)xSSProtection.getModeBlock()).endElement();
                        }
                        if (xSSProtection.getReportUri() != null) {
                            xmlWriter.startElement("ReportUri").value(xSSProtection.getReportUri()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((frameOptions = securityHeadersConfig.getFrameOptions()) != null) {
                        xmlWriter.startElement("FrameOptions");
                        if (frameOptions.getOverride() != null) {
                            xmlWriter.startElement("Override").value((Object)frameOptions.getOverride()).endElement();
                        }
                        if (frameOptions.getFrameOption() != null) {
                            xmlWriter.startElement("FrameOption").value(frameOptions.getFrameOption()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((referrerPolicy = securityHeadersConfig.getReferrerPolicy()) != null) {
                        xmlWriter.startElement("ReferrerPolicy");
                        if (referrerPolicy.getOverride() != null) {
                            xmlWriter.startElement("Override").value((Object)referrerPolicy.getOverride()).endElement();
                        }
                        if (referrerPolicy.getReferrerPolicy() != null) {
                            xmlWriter.startElement("ReferrerPolicy").value(referrerPolicy.getReferrerPolicy()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((contentSecurityPolicy = securityHeadersConfig.getContentSecurityPolicy()) != null) {
                        xmlWriter.startElement("ContentSecurityPolicy");
                        if (contentSecurityPolicy.getOverride() != null) {
                            xmlWriter.startElement("Override").value((Object)contentSecurityPolicy.getOverride()).endElement();
                        }
                        if (contentSecurityPolicy.getContentSecurityPolicy() != null) {
                            xmlWriter.startElement("ContentSecurityPolicy").value(contentSecurityPolicy.getContentSecurityPolicy()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((contentTypeOptions = securityHeadersConfig.getContentTypeOptions()) != null) {
                        xmlWriter.startElement("ContentTypeOptions");
                        if (contentTypeOptions.getOverride() != null) {
                            xmlWriter.startElement("Override").value((Object)contentTypeOptions.getOverride()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((strictTransportSecurity = securityHeadersConfig.getStrictTransportSecurity()) != null) {
                        xmlWriter.startElement("StrictTransportSecurity");
                        if (strictTransportSecurity.getOverride() != null) {
                            xmlWriter.startElement("Override").value((Object)strictTransportSecurity.getOverride()).endElement();
                        }
                        if (strictTransportSecurity.getIncludeSubdomains() != null) {
                            xmlWriter.startElement("IncludeSubdomains").value((Object)strictTransportSecurity.getIncludeSubdomains()).endElement();
                        }
                        if (strictTransportSecurity.getPreload() != null) {
                            xmlWriter.startElement("Preload").value((Object)strictTransportSecurity.getPreload()).endElement();
                        }
                        if (strictTransportSecurity.getAccessControlMaxAgeSec() != null) {
                            xmlWriter.startElement("AccessControlMaxAgeSec").value((Object)strictTransportSecurity.getAccessControlMaxAgeSec()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((customHeadersConfig = responseHeadersPolicyConfig.getCustomHeadersConfig()) != null) {
                    SdkInternalList responseHeadersPolicyCustomHeadersConfigItemsList;
                    xmlWriter.startElement("CustomHeadersConfig");
                    if (customHeadersConfig.getQuantity() != null) {
                        xmlWriter.startElement("Quantity").value((Object)customHeadersConfig.getQuantity()).endElement();
                    }
                    if (!(responseHeadersPolicyCustomHeadersConfigItemsList = (SdkInternalList)customHeadersConfig.getItems()).isEmpty() || !responseHeadersPolicyCustomHeadersConfigItemsList.isAutoConstruct()) {
                        xmlWriter.startElement("Items");
                        for (ResponseHeadersPolicyCustomHeader responseHeadersPolicyCustomHeadersConfigItemsListValue : responseHeadersPolicyCustomHeadersConfigItemsList) {
                            xmlWriter.startElement("ResponseHeadersPolicyCustomHeader");
                            if (responseHeadersPolicyCustomHeadersConfigItemsListValue.getHeader() != null) {
                                xmlWriter.startElement("Header").value(responseHeadersPolicyCustomHeadersConfigItemsListValue.getHeader()).endElement();
                            }
                            if (responseHeadersPolicyCustomHeadersConfigItemsListValue.getValue() != null) {
                                xmlWriter.startElement("Value").value(responseHeadersPolicyCustomHeadersConfigItemsListValue.getValue()).endElement();
                            }
                            if (responseHeadersPolicyCustomHeadersConfigItemsListValue.getOverride() != null) {
                                xmlWriter.startElement("Override").value((Object)responseHeadersPolicyCustomHeadersConfigItemsListValue.getOverride()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

