/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.cloudfront.util.SignerUtils;
import com.amazonaws.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public enum CloudFrontCookieSigner {

    private static final String EXPIRES_KEY = "CloudFront-Expires";
    private static final String SIGNATURE_KEY = "CloudFront-Signature";
    private static final String POLICY_KEY = "CloudFront-Policy";
    private static final String KEY_PAIR_ID_KEY = "CloudFront-Key-Pair-Id";

    public static CookiesForCannedPolicy getCookiesForCannedPolicy(SignerUtils.Protocol protocol, String distributionDomain, File privateKeyFile, String resourcePath, String keyPairId, Date expiresOn) throws InvalidKeySpecException, IOException {
        PrivateKey privateKey = SignerUtils.loadPrivateKey(privateKeyFile);
        return CloudFrontCookieSigner.getCookiesForCannedPolicy(protocol, distributionDomain, privateKey, resourcePath, keyPairId, expiresOn);
    }

    public static CookiesForCannedPolicy getCookiesForCannedPolicy(SignerUtils.Protocol protocol, String distributionDomain, PrivateKey privateKey, String resourcePath, String keyPairId, Date expiresOn) {
        String url = SignerUtils.generateResourcePath(protocol, distributionDomain, resourcePath);
        return CloudFrontCookieSigner.getCookiesForCannedPolicy(url, keyPairId, privateKey, expiresOn);
    }

    public static CookiesForCannedPolicy getCookiesForCannedPolicy(String resourceUrlOrPath, String keyPairId, File privateKeyFile, Date expiresOn) throws InvalidKeySpecException, IOException {
        PrivateKey privateKey = SignerUtils.loadPrivateKey(privateKeyFile);
        return CloudFrontCookieSigner.getCookiesForCannedPolicy(resourceUrlOrPath, keyPairId, privateKey, expiresOn);
    }

    public static CookiesForCannedPolicy getCookiesForCannedPolicy(String resourceUrlOrPath, String keyPairId, PrivateKey privateKey, Date expiresOn) {
        try {
            String cannedPolicy = SignerUtils.buildCannedPolicy(resourceUrlOrPath, expiresOn);
            byte[] signatureBytes = SignerUtils.signWithSha1RSA(cannedPolicy.getBytes(StringUtils.UTF8), privateKey);
            String urlSafeSignature = SignerUtils.makeBytesUrlSafe(signatureBytes);
            CookiesForCannedPolicy cookies = new CookiesForCannedPolicy();
            cookies.setExpires(String.valueOf(TimeUnit.MILLISECONDS.toSeconds(expiresOn.getTime())));
            cookies.setSignature(urlSafeSignature);
            cookies.setKeyPairId(keyPairId);
            return cookies;
        }
        catch (InvalidKeyException e) {
            throw new AmazonClientException("Couldn't sign canned policy cookie", (Throwable)e);
        }
    }

    public static CookiesForCustomPolicy getCookiesForCustomPolicy(SignerUtils.Protocol protocol, String distributionDomain, File privateKeyFile, String resourcePath, String keyPairId, Date expiresOn, Date activeFrom, String ipRange) throws InvalidKeySpecException, IOException {
        PrivateKey privateKey = SignerUtils.loadPrivateKey(privateKeyFile);
        return CloudFrontCookieSigner.getCookiesForCustomPolicy(protocol, distributionDomain, privateKey, resourcePath, keyPairId, expiresOn, activeFrom, ipRange);
    }

    public static CookiesForCustomPolicy getCookiesForCustomPolicy(SignerUtils.Protocol protocol, String distributionDomain, PrivateKey privateKey, String resourcePath, String keyPairId, Date expiresOn, Date activeFrom, String ipRange) {
        String url = SignerUtils.generateResourcePath(protocol, distributionDomain, resourcePath);
        return CloudFrontCookieSigner.getCookiesForCustomPolicy(url, privateKey, keyPairId, expiresOn, activeFrom, ipRange);
    }

    public static CookiesForCustomPolicy getCookiesForCustomPolicy(String resourceUrlOrPath, PrivateKey privateKey, String keyPairId, Date expiresOn, Date activeFrom, String ipRange) {
        try {
            String policy = SignerUtils.buildCustomPolicy(resourceUrlOrPath, expiresOn, activeFrom, ipRange);
            byte[] signatureBytes = SignerUtils.signWithSha1RSA(policy.getBytes(StringUtils.UTF8), privateKey);
            String urlSafePolicy = SignerUtils.makeStringUrlSafe(policy);
            String urlSafeSignature = SignerUtils.makeBytesUrlSafe(signatureBytes);
            CookiesForCustomPolicy cookies = new CookiesForCustomPolicy();
            cookies.setPolicy(urlSafePolicy);
            cookies.setSignature(urlSafeSignature);
            cookies.setKeyPairId(keyPairId);
            return cookies;
        }
        catch (InvalidKeyException e) {
            throw new AmazonClientException("Couldn't sign custom policy cookie", (Throwable)e);
        }
    }

    public static CookiesForCustomPolicy getCookiesForCustomPolicy(SignerUtils.Protocol protocol, String distributionDomain, PrivateKey privateKey, String resourcePath, String keyPairId, Date expiresOn, String ipRange) {
        return CloudFrontCookieSigner.getCookiesForCustomPolicy(protocol, distributionDomain, privateKey, resourcePath, keyPairId, expiresOn, null, ipRange);
    }

    public static class CookiesForCustomPolicy
    extends SignedCookies {
        public Map.Entry<String, String> policy;

        public Map.Entry<String, String> getPolicy() {
            return this.policy;
        }

        public void setPolicy(String policy) {
            this.policy = new SignedCookies.CookieKeyValuePair(CloudFrontCookieSigner.POLICY_KEY, policy);
        }
    }

    public static class CookiesForCannedPolicy
    extends SignedCookies {
        public Map.Entry<String, String> expires;

        public Map.Entry<String, String> getExpires() {
            return this.expires;
        }

        public void setExpires(String expires) {
            this.expires = new SignedCookies.CookieKeyValuePair(CloudFrontCookieSigner.EXPIRES_KEY, expires);
        }
    }

    public static class SignedCookies {
        protected Map.Entry<String, String> keyPairId;
        protected Map.Entry<String, String> signature;

        public Map.Entry<String, String> getKeyPairId() {
            return this.keyPairId;
        }

        public void setKeyPairId(String keyPairId) {
            this.keyPairId = new CookieKeyValuePair(CloudFrontCookieSigner.KEY_PAIR_ID_KEY, keyPairId);
        }

        public Map.Entry<String, String> getSignature() {
            return this.signature;
        }

        public void setSignature(String signature) {
            this.signature = new CookieKeyValuePair(CloudFrontCookieSigner.SIGNATURE_KEY, signature);
        }

        protected static class CookieKeyValuePair
        implements Map.Entry<String, String> {
            private String key;
            private String value;

            public CookieKeyValuePair(String key, String value) {
                this.key = key;
                this.value = value;
            }

            @Override
            public String getKey() {
                return this.key;
            }

            @Override
            public String getValue() {
                return this.value;
            }

            @Override
            public String setValue(String value) {
                String originalValue = this.value;
                this.value = value;
                return originalValue;
            }
        }
    }
}

