/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.CreatePublicKeyRequest;
import com.amazonaws.services.cloudfront.model.PublicKeyConfig;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreatePublicKeyRequestMarshaller
implements Marshaller<Request<CreatePublicKeyRequest>, CreatePublicKeyRequest> {
    public Request<CreatePublicKeyRequest> marshall(CreatePublicKeyRequest createPublicKeyRequest) {
        if (createPublicKeyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createPublicKeyRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2019-03-26/public-key";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://cloudfront.amazonaws.com/doc/2019-03-26/");
            PublicKeyConfig publicKeyConfig = createPublicKeyRequest.getPublicKeyConfig();
            if (publicKeyConfig != null) {
                xmlWriter.startElement("PublicKeyConfig");
                if (publicKeyConfig.getCallerReference() != null) {
                    xmlWriter.startElement("CallerReference").value(publicKeyConfig.getCallerReference()).endElement();
                }
                if (publicKeyConfig.getName() != null) {
                    xmlWriter.startElement("Name").value(publicKeyConfig.getName()).endElement();
                }
                if (publicKeyConfig.getEncodedKey() != null) {
                    xmlWriter.startElement("EncodedKey").value(publicKeyConfig.getEncodedKey()).endElement();
                }
                if (publicKeyConfig.getComment() != null) {
                    xmlWriter.startElement("Comment").value(publicKeyConfig.getComment()).endElement();
                }
                xmlWriter.endElement();
            }
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

