/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudfront.model.TagKeys;
import com.amazonaws.services.cloudfront.model.UntagResourceRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.UriResourcePathUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class UntagResourceRequestMarshaller
implements Marshaller<Request<UntagResourceRequest>, UntagResourceRequest> {
    public Request<UntagResourceRequest> marshall(UntagResourceRequest untagResourceRequest) {
        if (untagResourceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)untagResourceRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2016-09-29/tagging?Operation=Untag";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest((Request)request, (String)uriResourcePath);
        request.setResourcePath(uriResourcePath);
        if (untagResourceRequest.getResource() != null) {
            request.addParameter("Resource", StringUtils.fromString((String)untagResourceRequest.getResource()));
        }
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://cloudfront.amazonaws.com/doc/2016-09-29/");
            TagKeys tagKeys = untagResourceRequest.getTagKeys();
            if (tagKeys != null) {
                xmlWriter.startElement("TagKeys");
                SdkInternalList tagKeysItemsList = (SdkInternalList)tagKeys.getItems();
                if (!tagKeysItemsList.isEmpty() || !tagKeysItemsList.isAutoConstruct()) {
                    xmlWriter.startElement("Items");
                    for (String tagKeysItemsListValue : tagKeysItemsList) {
                        xmlWriter.startElement("Key");
                        xmlWriter.value(tagKeysItemsListValue);
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

