/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.ListInvalidationsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListInvalidationsRequestMarshaller
implements Marshaller<Request<ListInvalidationsRequest>, ListInvalidationsRequest> {
    public Request<ListInvalidationsRequest> marshall(ListInvalidationsRequest listInvalidationsRequest) {
        String maxItems;
        String marker;
        if (listInvalidationsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listInvalidationsRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2016-01-13/distribution/{DistributionId}/invalidation";
        uriResourcePath = uriResourcePath.replace("{DistributionId}", listInvalidationsRequest.getDistributionId() == null ? "" : StringUtils.fromString((String)listInvalidationsRequest.getDistributionId()));
        request.setResourcePath(uriResourcePath);
        String string = marker = listInvalidationsRequest.getMarker() == null ? null : StringUtils.fromString((String)listInvalidationsRequest.getMarker());
        if (marker != null) {
            request.addParameter("Marker", marker);
        }
        String string2 = maxItems = listInvalidationsRequest.getMaxItems() == null ? null : StringUtils.fromString((String)listInvalidationsRequest.getMaxItems());
        if (maxItems != null) {
            request.addParameter("MaxItems", maxItems);
        }
        return request;
    }
}

