/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.ListDistributionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListDistributionsRequestMarshaller
implements Marshaller<Request<ListDistributionsRequest>, ListDistributionsRequest> {
    public Request<ListDistributionsRequest> marshall(ListDistributionsRequest listDistributionsRequest) {
        String maxItems;
        String marker;
        if (listDistributionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listDistributionsRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2016-01-13/distribution";
        request.setResourcePath(uriResourcePath);
        String string = marker = listDistributionsRequest.getMarker() == null ? null : StringUtils.fromString((String)listDistributionsRequest.getMarker());
        if (marker != null) {
            request.addParameter("Marker", marker);
        }
        String string2 = maxItems = listDistributionsRequest.getMaxItems() == null ? null : StringUtils.fromString((String)listDistributionsRequest.getMaxItems());
        if (maxItems != null) {
            request.addParameter("MaxItems", maxItems);
        }
        return request;
    }
}

