/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.GetInvalidationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetInvalidationRequestMarshaller
implements Marshaller<Request<GetInvalidationRequest>, GetInvalidationRequest> {
    public Request<GetInvalidationRequest> marshall(GetInvalidationRequest getInvalidationRequest) {
        if (getInvalidationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getInvalidationRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2016-01-13/distribution/{DistributionId}/invalidation/{Id}";
        uriResourcePath = uriResourcePath.replace("{DistributionId}", getInvalidationRequest.getDistributionId() == null ? "" : StringUtils.fromString((String)getInvalidationRequest.getDistributionId()));
        uriResourcePath = uriResourcePath.replace("{Id}", getInvalidationRequest.getId() == null ? "" : StringUtils.fromString((String)getInvalidationRequest.getId()));
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

