/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.services.cloudformation.model.Warnings;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class WarningsStaxUnmarshaller
implements Unmarshaller<Warnings, StaxUnmarshallerContext> {
    private static WarningsStaxUnmarshaller instance;

    public Warnings unmarshall(StaxUnmarshallerContext context) throws Exception {
        Warnings warnings = new Warnings();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return warnings;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("UnrecognizedResourceTypes", targetDepth)) {
                    warnings.withUnrecognizedResourceTypes(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("UnrecognizedResourceTypes/member", targetDepth)) continue;
                warnings.withUnrecognizedResourceTypes(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return warnings;
    }

    public static WarningsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new WarningsStaxUnmarshaller();
        }
        return instance;
    }
}

