/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.CreateStackRequest;
import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.cloudformation.model.RollbackConfiguration;
import com.amazonaws.services.cloudformation.model.RollbackTrigger;
import com.amazonaws.services.cloudformation.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateStackRequestMarshaller
implements Marshaller<Request<CreateStackRequest>, CreateStackRequest> {
    public Request<CreateStackRequest> marshall(CreateStackRequest createStackRequest) {
        RollbackConfiguration rollbackConfiguration;
        if (createStackRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createStackRequest, "AmazonCloudFormation");
        request.addParameter("Action", "CreateStack");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createStackRequest.getStackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)createStackRequest.getStackName()));
        }
        if (createStackRequest.getTemplateBody() != null) {
            request.addParameter("TemplateBody", StringUtils.fromString((String)createStackRequest.getTemplateBody()));
        }
        if (createStackRequest.getTemplateURL() != null) {
            request.addParameter("TemplateURL", StringUtils.fromString((String)createStackRequest.getTemplateURL()));
        }
        if (createStackRequest.getParameters().isEmpty() && !((SdkInternalList)createStackRequest.getParameters()).isAutoConstruct()) {
            request.addParameter("Parameters", "");
        }
        if (!createStackRequest.getParameters().isEmpty() || !((SdkInternalList)createStackRequest.getParameters()).isAutoConstruct()) {
            SdkInternalList parametersList = (SdkInternalList)createStackRequest.getParameters();
            int parametersListIndex = 1;
            for (Object parametersListValue : parametersList) {
                if (parametersListValue != null) {
                    if (((Parameter)parametersListValue).getParameterKey() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey", StringUtils.fromString((String)((Parameter)parametersListValue).getParameterKey()));
                    }
                    if (((Parameter)parametersListValue).getParameterValue() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue", StringUtils.fromString((String)((Parameter)parametersListValue).getParameterValue()));
                    }
                    if (((Parameter)parametersListValue).getUsePreviousValue() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue", StringUtils.fromBoolean((Boolean)((Parameter)parametersListValue).getUsePreviousValue()));
                    }
                    if (((Parameter)parametersListValue).getResolvedValue() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".ResolvedValue", StringUtils.fromString((String)((Parameter)parametersListValue).getResolvedValue()));
                    }
                }
                ++parametersListIndex;
            }
        }
        if (createStackRequest.getDisableRollback() != null) {
            request.addParameter("DisableRollback", StringUtils.fromBoolean((Boolean)createStackRequest.getDisableRollback()));
        }
        if ((rollbackConfiguration = createStackRequest.getRollbackConfiguration()) != null) {
            if (rollbackConfiguration.getRollbackTriggers().isEmpty() && !((SdkInternalList)rollbackConfiguration.getRollbackTriggers()).isAutoConstruct()) {
                request.addParameter("RollbackConfiguration.RollbackTriggers", "");
            }
            if (!rollbackConfiguration.getRollbackTriggers().isEmpty() || !((SdkInternalList)rollbackConfiguration.getRollbackTriggers()).isAutoConstruct()) {
                SdkInternalList rollbackTriggersList = (SdkInternalList)rollbackConfiguration.getRollbackTriggers();
                int rollbackTriggersListIndex = 1;
                for (RollbackTrigger rollbackTriggersListValue : rollbackTriggersList) {
                    if (rollbackTriggersListValue != null) {
                        if (rollbackTriggersListValue.getArn() != null) {
                            request.addParameter("RollbackConfiguration.RollbackTriggers.member." + rollbackTriggersListIndex + ".Arn", StringUtils.fromString((String)rollbackTriggersListValue.getArn()));
                        }
                        if (rollbackTriggersListValue.getType() != null) {
                            request.addParameter("RollbackConfiguration.RollbackTriggers.member." + rollbackTriggersListIndex + ".Type", StringUtils.fromString((String)rollbackTriggersListValue.getType()));
                        }
                    }
                    ++rollbackTriggersListIndex;
                }
            }
            if (rollbackConfiguration.getMonitoringTimeInMinutes() != null) {
                request.addParameter("RollbackConfiguration.MonitoringTimeInMinutes", StringUtils.fromInteger((Integer)rollbackConfiguration.getMonitoringTimeInMinutes()));
            }
        }
        if (createStackRequest.getTimeoutInMinutes() != null) {
            request.addParameter("TimeoutInMinutes", StringUtils.fromInteger((Integer)createStackRequest.getTimeoutInMinutes()));
        }
        if (createStackRequest.getNotificationARNs().isEmpty() && !((SdkInternalList)createStackRequest.getNotificationARNs()).isAutoConstruct()) {
            request.addParameter("NotificationARNs", "");
        }
        if (!createStackRequest.getNotificationARNs().isEmpty() || !((SdkInternalList)createStackRequest.getNotificationARNs()).isAutoConstruct()) {
            SdkInternalList notificationARNsList = (SdkInternalList)createStackRequest.getNotificationARNs();
            int notificationARNsListIndex = 1;
            for (String notificationARNsListValue : notificationARNsList) {
                if (notificationARNsListValue != null) {
                    request.addParameter("NotificationARNs.member." + notificationARNsListIndex, StringUtils.fromString((String)notificationARNsListValue));
                }
                ++notificationARNsListIndex;
            }
        }
        if (createStackRequest.getCapabilities().isEmpty() && !((SdkInternalList)createStackRequest.getCapabilities()).isAutoConstruct()) {
            request.addParameter("Capabilities", "");
        }
        if (!createStackRequest.getCapabilities().isEmpty() || !((SdkInternalList)createStackRequest.getCapabilities()).isAutoConstruct()) {
            SdkInternalList capabilitiesList = (SdkInternalList)createStackRequest.getCapabilities();
            int capabilitiesListIndex = 1;
            for (String capabilitiesListValue : capabilitiesList) {
                if (capabilitiesListValue != null) {
                    request.addParameter("Capabilities.member." + capabilitiesListIndex, StringUtils.fromString((String)capabilitiesListValue));
                }
                ++capabilitiesListIndex;
            }
        }
        if (createStackRequest.getResourceTypes().isEmpty() && !((SdkInternalList)createStackRequest.getResourceTypes()).isAutoConstruct()) {
            request.addParameter("ResourceTypes", "");
        }
        if (!createStackRequest.getResourceTypes().isEmpty() || !((SdkInternalList)createStackRequest.getResourceTypes()).isAutoConstruct()) {
            SdkInternalList resourceTypesList = (SdkInternalList)createStackRequest.getResourceTypes();
            int resourceTypesListIndex = 1;
            for (String resourceTypesListValue : resourceTypesList) {
                if (resourceTypesListValue != null) {
                    request.addParameter("ResourceTypes.member." + resourceTypesListIndex, StringUtils.fromString((String)resourceTypesListValue));
                }
                ++resourceTypesListIndex;
            }
        }
        if (createStackRequest.getRoleARN() != null) {
            request.addParameter("RoleARN", StringUtils.fromString((String)createStackRequest.getRoleARN()));
        }
        if (createStackRequest.getOnFailure() != null) {
            request.addParameter("OnFailure", StringUtils.fromString((String)createStackRequest.getOnFailure()));
        }
        if (createStackRequest.getStackPolicyBody() != null) {
            request.addParameter("StackPolicyBody", StringUtils.fromString((String)createStackRequest.getStackPolicyBody()));
        }
        if (createStackRequest.getStackPolicyURL() != null) {
            request.addParameter("StackPolicyURL", StringUtils.fromString((String)createStackRequest.getStackPolicyURL()));
        }
        if (createStackRequest.getTags().isEmpty() && !((SdkInternalList)createStackRequest.getTags()).isAutoConstruct()) {
            request.addParameter("Tags", "");
        }
        if (!createStackRequest.getTags().isEmpty() || !((SdkInternalList)createStackRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createStackRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        if (createStackRequest.getClientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringUtils.fromString((String)createStackRequest.getClientRequestToken()));
        }
        if (createStackRequest.getEnableTerminationProtection() != null) {
            request.addParameter("EnableTerminationProtection", StringUtils.fromBoolean((Boolean)createStackRequest.getEnableTerminationProtection()));
        }
        if (createStackRequest.getRetainExceptOnCreate() != null) {
            request.addParameter("RetainExceptOnCreate", StringUtils.fromBoolean((Boolean)createStackRequest.getRetainExceptOnCreate()));
        }
        return request;
    }
}

