/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.cloudformation.model.RollbackConfiguration;
import com.amazonaws.services.cloudformation.model.RollbackTrigger;
import com.amazonaws.services.cloudformation.model.Tag;
import com.amazonaws.services.cloudformation.model.UpdateStackRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class UpdateStackRequestMarshaller
implements Marshaller<Request<UpdateStackRequest>, UpdateStackRequest> {
    public Request<UpdateStackRequest> marshall(UpdateStackRequest updateStackRequest) {
        RollbackConfiguration rollbackConfiguration;
        if (updateStackRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateStackRequest, "AmazonCloudFormation");
        request.addParameter("Action", "UpdateStack");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateStackRequest.getStackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)updateStackRequest.getStackName()));
        }
        if (updateStackRequest.getTemplateBody() != null) {
            request.addParameter("TemplateBody", StringUtils.fromString((String)updateStackRequest.getTemplateBody()));
        }
        if (updateStackRequest.getTemplateURL() != null) {
            request.addParameter("TemplateURL", StringUtils.fromString((String)updateStackRequest.getTemplateURL()));
        }
        if (updateStackRequest.getUsePreviousTemplate() != null) {
            request.addParameter("UsePreviousTemplate", StringUtils.fromBoolean((Boolean)updateStackRequest.getUsePreviousTemplate()));
        }
        if (updateStackRequest.getStackPolicyDuringUpdateBody() != null) {
            request.addParameter("StackPolicyDuringUpdateBody", StringUtils.fromString((String)updateStackRequest.getStackPolicyDuringUpdateBody()));
        }
        if (updateStackRequest.getStackPolicyDuringUpdateURL() != null) {
            request.addParameter("StackPolicyDuringUpdateURL", StringUtils.fromString((String)updateStackRequest.getStackPolicyDuringUpdateURL()));
        }
        if (updateStackRequest.getParameters().isEmpty() && !((SdkInternalList)updateStackRequest.getParameters()).isAutoConstruct()) {
            request.addParameter("Parameters", "");
        }
        if (!updateStackRequest.getParameters().isEmpty() || !((SdkInternalList)updateStackRequest.getParameters()).isAutoConstruct()) {
            SdkInternalList parametersList = (SdkInternalList)updateStackRequest.getParameters();
            int parametersListIndex = 1;
            for (Parameter parametersListValue : parametersList) {
                if (parametersListValue != null) {
                    if (parametersListValue.getParameterKey() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey", StringUtils.fromString((String)parametersListValue.getParameterKey()));
                    }
                    if (parametersListValue.getParameterValue() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue", StringUtils.fromString((String)parametersListValue.getParameterValue()));
                    }
                    if (parametersListValue.getUsePreviousValue() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue", StringUtils.fromBoolean((Boolean)parametersListValue.getUsePreviousValue()));
                    }
                    if (parametersListValue.getResolvedValue() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".ResolvedValue", StringUtils.fromString((String)parametersListValue.getResolvedValue()));
                    }
                }
                ++parametersListIndex;
            }
        }
        if (updateStackRequest.getCapabilities().isEmpty() && !((SdkInternalList)updateStackRequest.getCapabilities()).isAutoConstruct()) {
            request.addParameter("Capabilities", "");
        }
        if (!updateStackRequest.getCapabilities().isEmpty() || !((SdkInternalList)updateStackRequest.getCapabilities()).isAutoConstruct()) {
            SdkInternalList capabilitiesList = (SdkInternalList)updateStackRequest.getCapabilities();
            int capabilitiesListIndex = 1;
            for (String capabilitiesListValue : capabilitiesList) {
                if (capabilitiesListValue != null) {
                    request.addParameter("Capabilities.member." + capabilitiesListIndex, StringUtils.fromString((String)capabilitiesListValue));
                }
                ++capabilitiesListIndex;
            }
        }
        if (updateStackRequest.getResourceTypes().isEmpty() && !((SdkInternalList)updateStackRequest.getResourceTypes()).isAutoConstruct()) {
            request.addParameter("ResourceTypes", "");
        }
        if (!updateStackRequest.getResourceTypes().isEmpty() || !((SdkInternalList)updateStackRequest.getResourceTypes()).isAutoConstruct()) {
            SdkInternalList resourceTypesList = (SdkInternalList)updateStackRequest.getResourceTypes();
            int resourceTypesListIndex = 1;
            for (Object resourceTypesListValue : resourceTypesList) {
                if (resourceTypesListValue != null) {
                    request.addParameter("ResourceTypes.member." + resourceTypesListIndex, StringUtils.fromString((String)resourceTypesListValue));
                }
                ++resourceTypesListIndex;
            }
        }
        if (updateStackRequest.getRoleARN() != null) {
            request.addParameter("RoleARN", StringUtils.fromString((String)updateStackRequest.getRoleARN()));
        }
        if ((rollbackConfiguration = updateStackRequest.getRollbackConfiguration()) != null) {
            if (rollbackConfiguration.getRollbackTriggers().isEmpty() && !((SdkInternalList)rollbackConfiguration.getRollbackTriggers()).isAutoConstruct()) {
                request.addParameter("RollbackConfiguration.RollbackTriggers", "");
            }
            if (!rollbackConfiguration.getRollbackTriggers().isEmpty() || !((SdkInternalList)rollbackConfiguration.getRollbackTriggers()).isAutoConstruct()) {
                SdkInternalList rollbackTriggersList = (SdkInternalList)rollbackConfiguration.getRollbackTriggers();
                int rollbackTriggersListIndex = 1;
                for (RollbackTrigger rollbackTriggersListValue : rollbackTriggersList) {
                    if (rollbackTriggersListValue != null) {
                        if (rollbackTriggersListValue.getArn() != null) {
                            request.addParameter("RollbackConfiguration.RollbackTriggers.member." + rollbackTriggersListIndex + ".Arn", StringUtils.fromString((String)rollbackTriggersListValue.getArn()));
                        }
                        if (rollbackTriggersListValue.getType() != null) {
                            request.addParameter("RollbackConfiguration.RollbackTriggers.member." + rollbackTriggersListIndex + ".Type", StringUtils.fromString((String)rollbackTriggersListValue.getType()));
                        }
                    }
                    ++rollbackTriggersListIndex;
                }
            }
            if (rollbackConfiguration.getMonitoringTimeInMinutes() != null) {
                request.addParameter("RollbackConfiguration.MonitoringTimeInMinutes", StringUtils.fromInteger((Integer)rollbackConfiguration.getMonitoringTimeInMinutes()));
            }
        }
        if (updateStackRequest.getStackPolicyBody() != null) {
            request.addParameter("StackPolicyBody", StringUtils.fromString((String)updateStackRequest.getStackPolicyBody()));
        }
        if (updateStackRequest.getStackPolicyURL() != null) {
            request.addParameter("StackPolicyURL", StringUtils.fromString((String)updateStackRequest.getStackPolicyURL()));
        }
        if (updateStackRequest.getNotificationARNs().isEmpty() && !((SdkInternalList)updateStackRequest.getNotificationARNs()).isAutoConstruct()) {
            request.addParameter("NotificationARNs", "");
        }
        if (!updateStackRequest.getNotificationARNs().isEmpty() || !((SdkInternalList)updateStackRequest.getNotificationARNs()).isAutoConstruct()) {
            SdkInternalList notificationARNsList = (SdkInternalList)updateStackRequest.getNotificationARNs();
            int notificationARNsListIndex = 1;
            for (String notificationARNsListValue : notificationARNsList) {
                if (notificationARNsListValue != null) {
                    request.addParameter("NotificationARNs.member." + notificationARNsListIndex, StringUtils.fromString((String)notificationARNsListValue));
                }
                ++notificationARNsListIndex;
            }
        }
        if (updateStackRequest.getTags().isEmpty() && !((SdkInternalList)updateStackRequest.getTags()).isAutoConstruct()) {
            request.addParameter("Tags", "");
        }
        if (!updateStackRequest.getTags().isEmpty() || !((SdkInternalList)updateStackRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)updateStackRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        if (updateStackRequest.getDisableRollback() != null) {
            request.addParameter("DisableRollback", StringUtils.fromBoolean((Boolean)updateStackRequest.getDisableRollback()));
        }
        if (updateStackRequest.getClientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringUtils.fromString((String)updateStackRequest.getClientRequestToken()));
        }
        return request;
    }
}

