/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.services.cloudformation.model.ScannedResourceIdentifier;
import com.amazonaws.transform.MapEntry;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.Map;
import javax.xml.stream.events.XMLEvent;

public class ScannedResourceIdentifierStaxUnmarshaller
implements Unmarshaller<ScannedResourceIdentifier, StaxUnmarshallerContext> {
    private static ScannedResourceIdentifierStaxUnmarshaller instance;

    public ScannedResourceIdentifier unmarshall(StaxUnmarshallerContext context) throws Exception {
        ScannedResourceIdentifier scannedResourceIdentifier = new ScannedResourceIdentifier();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return scannedResourceIdentifier;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ResourceType", targetDepth)) {
                    scannedResourceIdentifier.setResourceType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ResourceIdentifier/entry", targetDepth)) continue;
                Map.Entry<String, String> entry = ResourceIdentifierMapEntryUnmarshaller.getInstance().unmarshall(context);
                scannedResourceIdentifier.addResourceIdentifierEntry(entry.getKey(), entry.getValue());
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return scannedResourceIdentifier;
    }

    public static ScannedResourceIdentifierStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ScannedResourceIdentifierStaxUnmarshaller();
        }
        return instance;
    }

    private static class ResourceIdentifierMapEntryUnmarshaller
    implements Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {
        private static ResourceIdentifierMapEntryUnmarshaller instance;

        private ResourceIdentifierMapEntryUnmarshaller() {
        }

        public Map.Entry<String, String> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            MapEntry entry = new MapEntry();
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    return entry;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("key", targetDepth)) {
                        entry.setKey((Object)SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("value", targetDepth)) continue;
                    entry.setValue((Object)SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            return entry;
        }

        public static ResourceIdentifierMapEntryUnmarshaller getInstance() {
            if (instance == null) {
                instance = new ResourceIdentifierMapEntryUnmarshaller();
            }
            return instance;
        }
    }
}

