/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.CreateGeneratedTemplateRequest;
import com.amazonaws.services.cloudformation.model.ResourceDefinition;
import com.amazonaws.services.cloudformation.model.TemplateConfiguration;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Map;

public class CreateGeneratedTemplateRequestMarshaller
implements Marshaller<Request<CreateGeneratedTemplateRequest>, CreateGeneratedTemplateRequest> {
    public Request<CreateGeneratedTemplateRequest> marshall(CreateGeneratedTemplateRequest createGeneratedTemplateRequest) {
        TemplateConfiguration templateConfiguration;
        if (createGeneratedTemplateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createGeneratedTemplateRequest, "AmazonCloudFormation");
        request.addParameter("Action", "CreateGeneratedTemplate");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createGeneratedTemplateRequest.getResources().isEmpty() && !((SdkInternalList)createGeneratedTemplateRequest.getResources()).isAutoConstruct()) {
            request.addParameter("Resources", "");
        }
        if (!createGeneratedTemplateRequest.getResources().isEmpty() || !((SdkInternalList)createGeneratedTemplateRequest.getResources()).isAutoConstruct()) {
            SdkInternalList resourcesList = (SdkInternalList)createGeneratedTemplateRequest.getResources();
            int resourcesListIndex = 1;
            for (ResourceDefinition resourcesListValue : resourcesList) {
                if (resourcesListValue != null) {
                    Map<String, String> resourceIdentifier;
                    if (resourcesListValue.getResourceType() != null) {
                        request.addParameter("Resources.member." + resourcesListIndex + ".ResourceType", StringUtils.fromString((String)resourcesListValue.getResourceType()));
                    }
                    if (resourcesListValue.getLogicalResourceId() != null) {
                        request.addParameter("Resources.member." + resourcesListIndex + ".LogicalResourceId", StringUtils.fromString((String)resourcesListValue.getLogicalResourceId()));
                    }
                    if ((resourceIdentifier = resourcesListValue.getResourceIdentifier()) != null) {
                        int resourceIdentifierListIndex = 1;
                        for (Map.Entry<String, String> entry : resourceIdentifier.entrySet()) {
                            if (entry != null && entry.getKey() != null) {
                                request.addParameter("Resources.member." + resourcesListIndex + ".ResourceIdentifier.entry." + resourceIdentifierListIndex + ".key", StringUtils.fromString((String)entry.getKey()));
                            }
                            if (entry != null && entry.getValue() != null) {
                                request.addParameter("Resources.member." + resourcesListIndex + ".ResourceIdentifier.entry." + resourceIdentifierListIndex + ".value", StringUtils.fromString((String)entry.getValue()));
                            }
                            ++resourceIdentifierListIndex;
                        }
                    }
                }
                ++resourcesListIndex;
            }
        }
        if (createGeneratedTemplateRequest.getGeneratedTemplateName() != null) {
            request.addParameter("GeneratedTemplateName", StringUtils.fromString((String)createGeneratedTemplateRequest.getGeneratedTemplateName()));
        }
        if (createGeneratedTemplateRequest.getStackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)createGeneratedTemplateRequest.getStackName()));
        }
        if ((templateConfiguration = createGeneratedTemplateRequest.getTemplateConfiguration()) != null) {
            if (templateConfiguration.getDeletionPolicy() != null) {
                request.addParameter("TemplateConfiguration.DeletionPolicy", StringUtils.fromString((String)templateConfiguration.getDeletionPolicy()));
            }
            if (templateConfiguration.getUpdateReplacePolicy() != null) {
                request.addParameter("TemplateConfiguration.UpdateReplacePolicy", StringUtils.fromString((String)templateConfiguration.getUpdateReplacePolicy()));
            }
        }
        return request;
    }
}

