/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.ResourceScanSummary;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListResourceScansResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<ResourceScanSummary> resourceScanSummaries;
    private String nextToken;

    public List<ResourceScanSummary> getResourceScanSummaries() {
        if (this.resourceScanSummaries == null) {
            this.resourceScanSummaries = new SdkInternalList();
        }
        return this.resourceScanSummaries;
    }

    public void setResourceScanSummaries(Collection<ResourceScanSummary> resourceScanSummaries) {
        if (resourceScanSummaries == null) {
            this.resourceScanSummaries = null;
            return;
        }
        this.resourceScanSummaries = new SdkInternalList(resourceScanSummaries);
    }

    public ListResourceScansResult withResourceScanSummaries(ResourceScanSummary ... resourceScanSummaries) {
        if (this.resourceScanSummaries == null) {
            this.setResourceScanSummaries((Collection<ResourceScanSummary>)new SdkInternalList(resourceScanSummaries.length));
        }
        for (ResourceScanSummary ele : resourceScanSummaries) {
            this.resourceScanSummaries.add((Object)ele);
        }
        return this;
    }

    public ListResourceScansResult withResourceScanSummaries(Collection<ResourceScanSummary> resourceScanSummaries) {
        this.setResourceScanSummaries(resourceScanSummaries);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListResourceScansResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceScanSummaries() != null) {
            sb.append("ResourceScanSummaries: ").append(this.getResourceScanSummaries()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceScansResult)) {
            return false;
        }
        ListResourceScansResult other = (ListResourceScansResult)obj;
        if (other.getResourceScanSummaries() == null ^ this.getResourceScanSummaries() == null) {
            return false;
        }
        if (other.getResourceScanSummaries() != null && !other.getResourceScanSummaries().equals(this.getResourceScanSummaries())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceScanSummaries() == null ? 0 : this.getResourceScanSummaries().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListResourceScansResult clone() {
        try {
            return (ListResourceScansResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

