/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.services.cloudformation.model.DeploymentTargets;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class DeploymentTargetsStaxUnmarshaller
implements Unmarshaller<DeploymentTargets, StaxUnmarshallerContext> {
    private static DeploymentTargetsStaxUnmarshaller instance;

    public DeploymentTargets unmarshall(StaxUnmarshallerContext context) throws Exception {
        DeploymentTargets deploymentTargets = new DeploymentTargets();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return deploymentTargets;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Accounts", targetDepth)) {
                    deploymentTargets.withAccounts(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("Accounts/member", targetDepth)) {
                    deploymentTargets.withAccounts(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AccountsUrl", targetDepth)) {
                    deploymentTargets.setAccountsUrl(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("OrganizationalUnitIds", targetDepth)) {
                    deploymentTargets.withOrganizationalUnitIds(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("OrganizationalUnitIds/member", targetDepth)) {
                    deploymentTargets.withOrganizationalUnitIds(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("AccountFilterType", targetDepth)) continue;
                deploymentTargets.setAccountFilterType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return deploymentTargets;
    }

    public static DeploymentTargetsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DeploymentTargetsStaxUnmarshaller();
        }
        return instance;
    }
}

