/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.StackInstanceFilter;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListStackInstancesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String stackSetName;
    private String nextToken;
    private Integer maxResults;
    private SdkInternalList<StackInstanceFilter> filters;
    private String stackInstanceAccount;
    private String stackInstanceRegion;

    public void setStackSetName(String stackSetName) {
        this.stackSetName = stackSetName;
    }

    public String getStackSetName() {
        return this.stackSetName;
    }

    public ListStackInstancesRequest withStackSetName(String stackSetName) {
        this.setStackSetName(stackSetName);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListStackInstancesRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListStackInstancesRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public List<StackInstanceFilter> getFilters() {
        if (this.filters == null) {
            this.filters = new SdkInternalList();
        }
        return this.filters;
    }

    public void setFilters(Collection<StackInstanceFilter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new SdkInternalList(filters);
    }

    public ListStackInstancesRequest withFilters(StackInstanceFilter ... filters) {
        if (this.filters == null) {
            this.setFilters((Collection<StackInstanceFilter>)new SdkInternalList(filters.length));
        }
        for (StackInstanceFilter ele : filters) {
            this.filters.add((Object)ele);
        }
        return this;
    }

    public ListStackInstancesRequest withFilters(Collection<StackInstanceFilter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setStackInstanceAccount(String stackInstanceAccount) {
        this.stackInstanceAccount = stackInstanceAccount;
    }

    public String getStackInstanceAccount() {
        return this.stackInstanceAccount;
    }

    public ListStackInstancesRequest withStackInstanceAccount(String stackInstanceAccount) {
        this.setStackInstanceAccount(stackInstanceAccount);
        return this;
    }

    public void setStackInstanceRegion(String stackInstanceRegion) {
        this.stackInstanceRegion = stackInstanceRegion;
    }

    public String getStackInstanceRegion() {
        return this.stackInstanceRegion;
    }

    public ListStackInstancesRequest withStackInstanceRegion(String stackInstanceRegion) {
        this.setStackInstanceRegion(stackInstanceRegion);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStackSetName() != null) {
            sb.append("StackSetName: ").append(this.getStackSetName()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getStackInstanceAccount() != null) {
            sb.append("StackInstanceAccount: ").append(this.getStackInstanceAccount()).append(",");
        }
        if (this.getStackInstanceRegion() != null) {
            sb.append("StackInstanceRegion: ").append(this.getStackInstanceRegion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStackInstancesRequest)) {
            return false;
        }
        ListStackInstancesRequest other = (ListStackInstancesRequest)obj;
        if (other.getStackSetName() == null ^ this.getStackSetName() == null) {
            return false;
        }
        if (other.getStackSetName() != null && !other.getStackSetName().equals(this.getStackSetName())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getStackInstanceAccount() == null ^ this.getStackInstanceAccount() == null) {
            return false;
        }
        if (other.getStackInstanceAccount() != null && !other.getStackInstanceAccount().equals(this.getStackInstanceAccount())) {
            return false;
        }
        if (other.getStackInstanceRegion() == null ^ this.getStackInstanceRegion() == null) {
            return false;
        }
        return other.getStackInstanceRegion() == null || other.getStackInstanceRegion().equals(this.getStackInstanceRegion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStackSetName() == null ? 0 : this.getStackSetName().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getStackInstanceAccount() == null ? 0 : this.getStackInstanceAccount().hashCode());
        hashCode = 31 * hashCode + (this.getStackInstanceRegion() == null ? 0 : this.getStackInstanceRegion().hashCode());
        return hashCode;
    }

    public ListStackInstancesRequest clone() {
        return (ListStackInstancesRequest)super.clone();
    }
}

