/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.cloudformation.model.StackSetOperationPreferences;
import com.amazonaws.services.cloudformation.model.Tag;
import com.amazonaws.services.cloudformation.model.UpdateStackSetRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class UpdateStackSetRequestMarshaller
implements Marshaller<Request<UpdateStackSetRequest>, UpdateStackSetRequest> {
    public Request<UpdateStackSetRequest> marshall(UpdateStackSetRequest updateStackSetRequest) {
        StackSetOperationPreferences operationPreferences;
        if (updateStackSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateStackSetRequest, "AmazonCloudFormation");
        request.addParameter("Action", "UpdateStackSet");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateStackSetRequest.getStackSetName() != null) {
            request.addParameter("StackSetName", StringUtils.fromString((String)updateStackSetRequest.getStackSetName()));
        }
        if (updateStackSetRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)updateStackSetRequest.getDescription()));
        }
        if (updateStackSetRequest.getTemplateBody() != null) {
            request.addParameter("TemplateBody", StringUtils.fromString((String)updateStackSetRequest.getTemplateBody()));
        }
        if (updateStackSetRequest.getTemplateURL() != null) {
            request.addParameter("TemplateURL", StringUtils.fromString((String)updateStackSetRequest.getTemplateURL()));
        }
        if (updateStackSetRequest.getUsePreviousTemplate() != null) {
            request.addParameter("UsePreviousTemplate", StringUtils.fromBoolean((Boolean)updateStackSetRequest.getUsePreviousTemplate()));
        }
        if (updateStackSetRequest.getParameters().isEmpty() && !((SdkInternalList)updateStackSetRequest.getParameters()).isAutoConstruct()) {
            request.addParameter("Parameters", "");
        }
        if (!updateStackSetRequest.getParameters().isEmpty() || !((SdkInternalList)updateStackSetRequest.getParameters()).isAutoConstruct()) {
            SdkInternalList parametersList = (SdkInternalList)updateStackSetRequest.getParameters();
            int parametersListIndex = 1;
            for (Parameter parametersListValue : parametersList) {
                if (parametersListValue.getParameterKey() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey", StringUtils.fromString((String)parametersListValue.getParameterKey()));
                }
                if (parametersListValue.getParameterValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue", StringUtils.fromString((String)parametersListValue.getParameterValue()));
                }
                if (parametersListValue.getUsePreviousValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue", StringUtils.fromBoolean((Boolean)parametersListValue.getUsePreviousValue()));
                }
                if (parametersListValue.getResolvedValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ResolvedValue", StringUtils.fromString((String)parametersListValue.getResolvedValue()));
                }
                ++parametersListIndex;
            }
        }
        if (updateStackSetRequest.getCapabilities().isEmpty() && !((SdkInternalList)updateStackSetRequest.getCapabilities()).isAutoConstruct()) {
            request.addParameter("Capabilities", "");
        }
        if (!updateStackSetRequest.getCapabilities().isEmpty() || !((SdkInternalList)updateStackSetRequest.getCapabilities()).isAutoConstruct()) {
            SdkInternalList capabilitiesList = (SdkInternalList)updateStackSetRequest.getCapabilities();
            int capabilitiesListIndex = 1;
            for (String capabilitiesListValue : capabilitiesList) {
                if (capabilitiesListValue != null) {
                    request.addParameter("Capabilities.member." + capabilitiesListIndex, StringUtils.fromString((String)capabilitiesListValue));
                }
                ++capabilitiesListIndex;
            }
        }
        if (updateStackSetRequest.getTags().isEmpty() && !((SdkInternalList)updateStackSetRequest.getTags()).isAutoConstruct()) {
            request.addParameter("Tags", "");
        }
        if (!updateStackSetRequest.getTags().isEmpty() || !((SdkInternalList)updateStackSetRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)updateStackSetRequest.getTags();
            int tagsListIndex = 1;
            for (Object tagsListValue : tagsList) {
                if (((Tag)tagsListValue).getKey() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString((String)((Tag)tagsListValue).getKey()));
                }
                if (((Tag)tagsListValue).getValue() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)((Tag)tagsListValue).getValue()));
                }
                ++tagsListIndex;
            }
        }
        if ((operationPreferences = updateStackSetRequest.getOperationPreferences()) != null) {
            if (operationPreferences.getRegionOrder().isEmpty() && !((SdkInternalList)operationPreferences.getRegionOrder()).isAutoConstruct()) {
                request.addParameter("OperationPreferences.RegionOrder", "");
            }
            if (!operationPreferences.getRegionOrder().isEmpty() || !((SdkInternalList)operationPreferences.getRegionOrder()).isAutoConstruct()) {
                SdkInternalList regionOrderList = (SdkInternalList)operationPreferences.getRegionOrder();
                int regionOrderListIndex = 1;
                for (String regionOrderListValue : regionOrderList) {
                    if (regionOrderListValue != null) {
                        request.addParameter("OperationPreferences.RegionOrder.member." + regionOrderListIndex, StringUtils.fromString((String)regionOrderListValue));
                    }
                    ++regionOrderListIndex;
                }
            }
            if (operationPreferences.getFailureToleranceCount() != null) {
                request.addParameter("OperationPreferences.FailureToleranceCount", StringUtils.fromInteger((Integer)operationPreferences.getFailureToleranceCount()));
            }
            if (operationPreferences.getFailureTolerancePercentage() != null) {
                request.addParameter("OperationPreferences.FailureTolerancePercentage", StringUtils.fromInteger((Integer)operationPreferences.getFailureTolerancePercentage()));
            }
            if (operationPreferences.getMaxConcurrentCount() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentCount", StringUtils.fromInteger((Integer)operationPreferences.getMaxConcurrentCount()));
            }
            if (operationPreferences.getMaxConcurrentPercentage() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentPercentage", StringUtils.fromInteger((Integer)operationPreferences.getMaxConcurrentPercentage()));
            }
        }
        if (updateStackSetRequest.getAdministrationRoleARN() != null) {
            request.addParameter("AdministrationRoleARN", StringUtils.fromString((String)updateStackSetRequest.getAdministrationRoleARN()));
        }
        if (updateStackSetRequest.getExecutionRoleName() != null) {
            request.addParameter("ExecutionRoleName", StringUtils.fromString((String)updateStackSetRequest.getExecutionRoleName()));
        }
        request.addParameter("OperationId", IdempotentUtils.resolveString((String)updateStackSetRequest.getOperationId()));
        if (updateStackSetRequest.getAccounts().isEmpty() && !((SdkInternalList)updateStackSetRequest.getAccounts()).isAutoConstruct()) {
            request.addParameter("Accounts", "");
        }
        if (!updateStackSetRequest.getAccounts().isEmpty() || !((SdkInternalList)updateStackSetRequest.getAccounts()).isAutoConstruct()) {
            SdkInternalList accountsList = (SdkInternalList)updateStackSetRequest.getAccounts();
            int accountsListIndex = 1;
            for (String accountsListValue : accountsList) {
                if (accountsListValue != null) {
                    request.addParameter("Accounts.member." + accountsListIndex, StringUtils.fromString((String)accountsListValue));
                }
                ++accountsListIndex;
            }
        }
        if (updateStackSetRequest.getRegions().isEmpty() && !((SdkInternalList)updateStackSetRequest.getRegions()).isAutoConstruct()) {
            request.addParameter("Regions", "");
        }
        if (!updateStackSetRequest.getRegions().isEmpty() || !((SdkInternalList)updateStackSetRequest.getRegions()).isAutoConstruct()) {
            SdkInternalList regionsList = (SdkInternalList)updateStackSetRequest.getRegions();
            int regionsListIndex = 1;
            for (String regionsListValue : regionsList) {
                if (regionsListValue != null) {
                    request.addParameter("Regions.member." + regionsListIndex, StringUtils.fromString((String)regionsListValue));
                }
                ++regionsListIndex;
            }
        }
        return request;
    }
}

