/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.clouddirectory.model.LinkAttributeUpdate;
import com.amazonaws.services.clouddirectory.model.TypedLinkSpecifier;
import com.amazonaws.services.clouddirectory.model.transform.BatchUpdateLinkAttributesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchUpdateLinkAttributes
implements Serializable,
Cloneable,
StructuredPojo {
    private TypedLinkSpecifier typedLinkSpecifier;
    private List<LinkAttributeUpdate> attributeUpdates;

    public void setTypedLinkSpecifier(TypedLinkSpecifier typedLinkSpecifier) {
        this.typedLinkSpecifier = typedLinkSpecifier;
    }

    public TypedLinkSpecifier getTypedLinkSpecifier() {
        return this.typedLinkSpecifier;
    }

    public BatchUpdateLinkAttributes withTypedLinkSpecifier(TypedLinkSpecifier typedLinkSpecifier) {
        this.setTypedLinkSpecifier(typedLinkSpecifier);
        return this;
    }

    public List<LinkAttributeUpdate> getAttributeUpdates() {
        return this.attributeUpdates;
    }

    public void setAttributeUpdates(Collection<LinkAttributeUpdate> attributeUpdates) {
        if (attributeUpdates == null) {
            this.attributeUpdates = null;
            return;
        }
        this.attributeUpdates = new ArrayList<LinkAttributeUpdate>(attributeUpdates);
    }

    public BatchUpdateLinkAttributes withAttributeUpdates(LinkAttributeUpdate ... attributeUpdates) {
        if (this.attributeUpdates == null) {
            this.setAttributeUpdates(new ArrayList<LinkAttributeUpdate>(attributeUpdates.length));
        }
        for (LinkAttributeUpdate ele : attributeUpdates) {
            this.attributeUpdates.add(ele);
        }
        return this;
    }

    public BatchUpdateLinkAttributes withAttributeUpdates(Collection<LinkAttributeUpdate> attributeUpdates) {
        this.setAttributeUpdates(attributeUpdates);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTypedLinkSpecifier() != null) {
            sb.append("TypedLinkSpecifier: ").append(this.getTypedLinkSpecifier()).append(",");
        }
        if (this.getAttributeUpdates() != null) {
            sb.append("AttributeUpdates: ").append(this.getAttributeUpdates());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateLinkAttributes)) {
            return false;
        }
        BatchUpdateLinkAttributes other = (BatchUpdateLinkAttributes)obj;
        if (other.getTypedLinkSpecifier() == null ^ this.getTypedLinkSpecifier() == null) {
            return false;
        }
        if (other.getTypedLinkSpecifier() != null && !other.getTypedLinkSpecifier().equals(this.getTypedLinkSpecifier())) {
            return false;
        }
        if (other.getAttributeUpdates() == null ^ this.getAttributeUpdates() == null) {
            return false;
        }
        return other.getAttributeUpdates() == null || other.getAttributeUpdates().equals(this.getAttributeUpdates());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTypedLinkSpecifier() == null ? 0 : this.getTypedLinkSpecifier().hashCode());
        hashCode = 31 * hashCode + (this.getAttributeUpdates() == null ? 0 : this.getAttributeUpdates().hashCode());
        return hashCode;
    }

    public BatchUpdateLinkAttributes clone() {
        try {
            return (BatchUpdateLinkAttributes)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchUpdateLinkAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

