/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.clouddirectory.model.PutSchemaFromJsonRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class PutSchemaFromJsonRequestMarshaller
implements Marshaller<Request<PutSchemaFromJsonRequest>, PutSchemaFromJsonRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public PutSchemaFromJsonRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<PutSchemaFromJsonRequest> marshall(PutSchemaFromJsonRequest putSchemaFromJsonRequest) {
        if (putSchemaFromJsonRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putSchemaFromJsonRequest, "AmazonCloudDirectory");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putSchemaFromJsonRequest.getSchemaArn() != null) {
            request.addHeader("x-amz-data-partition", StringUtils.fromString((String)putSchemaFromJsonRequest.getSchemaArn()));
        }
        String uriResourcePath = "/amazonclouddirectory/2017-01-11/schema/json";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (putSchemaFromJsonRequest.getDocument() != null) {
                jsonGenerator.writeFieldName("Document").writeValue(putSchemaFromJsonRequest.getDocument());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

