/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.clouddirectory.model.PolicyAttachment;
import com.amazonaws.services.clouddirectory.model.PolicyToPath;
import com.amazonaws.services.clouddirectory.model.transform.PolicyAttachmentJsonMarshaller;
import java.util.List;

public class PolicyToPathJsonMarshaller {
    private static PolicyToPathJsonMarshaller instance;

    public void marshall(PolicyToPath policyToPath, StructuredJsonGenerator jsonGenerator) {
        if (policyToPath == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<PolicyAttachment> policiesList;
            jsonGenerator.writeStartObject();
            if (policyToPath.getPath() != null) {
                jsonGenerator.writeFieldName("Path").writeValue(policyToPath.getPath());
            }
            if ((policiesList = policyToPath.getPolicies()) != null) {
                jsonGenerator.writeFieldName("Policies");
                jsonGenerator.writeStartArray();
                for (PolicyAttachment policiesListValue : policiesList) {
                    if (policiesListValue == null) continue;
                    PolicyAttachmentJsonMarshaller.getInstance().marshall(policiesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PolicyToPathJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PolicyToPathJsonMarshaller();
        }
        return instance;
    }
}

