/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.clouddirectory.model.AttributeKeyAndValue;
import com.amazonaws.services.clouddirectory.model.IndexAttachment;
import com.amazonaws.services.clouddirectory.model.transform.AttributeKeyAndValueJsonMarshaller;
import java.util.List;

public class IndexAttachmentJsonMarshaller {
    private static IndexAttachmentJsonMarshaller instance;

    public void marshall(IndexAttachment indexAttachment, StructuredJsonGenerator jsonGenerator) {
        if (indexAttachment == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            List<AttributeKeyAndValue> indexedAttributesList = indexAttachment.getIndexedAttributes();
            if (indexedAttributesList != null) {
                jsonGenerator.writeFieldName("IndexedAttributes");
                jsonGenerator.writeStartArray();
                for (AttributeKeyAndValue indexedAttributesListValue : indexedAttributesList) {
                    if (indexedAttributesListValue == null) continue;
                    AttributeKeyAndValueJsonMarshaller.getInstance().marshall(indexedAttributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (indexAttachment.getObjectIdentifier() != null) {
                jsonGenerator.writeFieldName("ObjectIdentifier").writeValue(indexAttachment.getObjectIdentifier());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static IndexAttachmentJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new IndexAttachmentJsonMarshaller();
        }
        return instance;
    }
}

